/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.beans.IProperties;
import ag.ion.bion.officelayer.internal.beans.AbstractPropertyStore;
import ag.ion.bion.officelayer.internal.text.TextTableColumnsSeparator;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableProperties;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.ITextTablePropertyStore;

public class TextTablePropertyStore
extends AbstractPropertyStore
implements ITextTablePropertyStore {
    private int[] cellWidth = null;
    private long tableWidth = -1L;
    private int columnCount = -1;
    private int rowCount = -1;
    private boolean repeatHeadline = false;
    private TextTableColumnsSeparator[] textTableColumnsSeparators = null;
    private IProperties properties = null;

    public TextTablePropertyStore(ITextTable table) throws TextException {
        this.getTableAnalyse(table);
    }

    @Override
    public IProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setCellWidths(int[] width) {
        this.cellWidth = width;
    }

    @Override
    public void setWidth(long width) {
        this.tableWidth = width;
    }

    @Override
    public void setRows(int number) {
        this.rowCount = number;
    }

    @Override
    public void setColumns(int number) {
        this.columnCount = number;
    }

    @Override
    public void setRepeatHeadline(boolean repeatHeadline) throws TextException {
        this.repeatHeadline = repeatHeadline;
    }

    @Override
    public boolean repeatHeadline() throws TextException {
        return this.repeatHeadline;
    }

    @Override
    public int[] getCellWidths() throws TextException {
        return this.cellWidth;
    }

    @Override
    public long getWidth() throws TextException {
        return this.tableWidth;
    }

    @Override
    public TextTableColumnsSeparator[] getTableColumnSeparators() throws TextException {
        return this.textTableColumnsSeparators;
    }

    @Override
    public void setTableColumnSeparators(TextTableColumnsSeparator[] textTableColumnsSeparators) throws TextException {
        this.textTableColumnsSeparators = textTableColumnsSeparators;
    }

    @Override
    public int getColumns() {
        return this.columnCount;
    }

    @Override
    public int getRows() {
        return this.rowCount;
    }

    private void getTableAnalyse(ITextTable table) throws TextException {
        ITextTableProperties props = table.getProperties();
        this.properties = props;
        this.columnCount = table.getColumnCount();
        this.rowCount = table.getRowCount();
        this.tableWidth = props.getWidth();
        this.cellWidth = props.getCellWidths();
        this.repeatHeadline = props.repeatHeadline();
        this.textTableColumnsSeparators = props.getTableColumnSeparators();
    }
}

