/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.internal.text.table.TextTableCellReference;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaExpression;
import java.util.ArrayList;
import java.util.List;

public class TextTableFormulaModel {
    private String formulaExpression = null;
    private List formulaElements = null;
    private List cellReferences = null;
    private List formulaElementsOrig = null;
    private List cellReferencesOrig = null;

    public TextTableFormulaModel(TextTableFormulaExpression textTableFormulaExpression) throws IllegalArgumentException {
        if (textTableFormulaExpression == null) {
            throw new IllegalArgumentException("The submitted formula expression is not valid.");
        }
        this.formulaExpression = textTableFormulaExpression.getExpression();
        this.init();
        this.parse();
    }

    private void init() {
        this.formulaElements = new ArrayList();
        this.cellReferences = new ArrayList();
    }

    public TextTableCellReference[] getCellReferences() {
        TextTableCellReference[] cellReference = new TextTableCellReference[this.cellReferences.size()];
        return this.cellReferences.toArray(cellReference);
    }

    public String getExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < this.formulaElements.size()) {
            stringBuffer.append(this.formulaElements.get(i).toString());
            ++i;
        }
        return stringBuffer.toString();
    }

    private void parse() {
        char[] formulaChars = this.formulaExpression.toCharArray();
        StringBuffer formulaPart = new StringBuffer();
        StringBuffer cellReferenceExpression = null;
        int i = 0;
        while (i < formulaChars.length) {
            if (formulaChars[i] == '<') {
                cellReferenceExpression = new StringBuffer();
                ++i;
                while (i < formulaChars.length) {
                    if (formulaChars[i] == '>') break;
                    cellReferenceExpression.append(formulaChars[i]);
                    ++i;
                }
                TextTableCellReference cellReference = new TextTableCellReference(cellReferenceExpression.toString());
                this.formulaElements.add(cellReference);
                this.cellReferences.add(cellReference);
                cellReferenceExpression = null;
                if (formulaPart.length() != 0) {
                    this.formulaElements.add(this.formulaElements.size() - 1, formulaPart);
                    formulaPart = new StringBuffer();
                }
            } else {
                formulaPart.append(formulaChars[i]);
            }
            ++i;
        }
        this.formulaElements.add(formulaPart);
        if (cellReferenceExpression != null) {
            this.formulaElements.add(cellReferenceExpression);
        }
    }

    public void replaceCellReference(TextTableCellReference textTableCellReference, TextTableCellReference[] textTableCellReferences) {
        if (this.formulaElementsOrig == null) {
            this.formulaElementsOrig = new ArrayList();
            this.cellReferencesOrig = new ArrayList();
            this.formulaElementsOrig.addAll(this.formulaElements);
            this.cellReferencesOrig.addAll(this.cellReferences);
        }
        int index = this.formulaElements.indexOf(textTableCellReference);
        this.formulaElements.set(index, "(");
        ++index;
        int referenceIndex = this.cellReferences.indexOf(textTableCellReference);
        this.cellReferences.remove(referenceIndex);
        ++referenceIndex;
        int i = 0;
        while (i < textTableCellReferences.length) {
            if (this.cellReferences.size() < referenceIndex) {
                this.cellReferences.add(textTableCellReferences[i]);
                ++referenceIndex;
            } else {
                this.cellReferences.add(referenceIndex, textTableCellReferences[i]);
                ++referenceIndex;
            }
            if (this.formulaElements.size() < index) {
                this.formulaElements.add(textTableCellReferences[i]);
                ++index;
                this.formulaElements.add("+");
                ++index;
            } else {
                this.formulaElements.add(index, textTableCellReferences[i]);
                if (this.formulaElements.size() < ++index) {
                    this.formulaElements.add("+");
                    ++index;
                } else {
                    this.formulaElements.add(index, "+");
                    ++index;
                }
            }
            ++i;
        }
        this.formulaElements.set(index - 1, ")");
    }

    public void revertToOriginal() {
        if (this.formulaElementsOrig != null) {
            this.formulaElements.clear();
            this.cellReferences.clear();
            this.formulaElements.addAll(this.formulaElementsOrig);
            this.cellReferences.addAll(this.cellReferencesOrig);
        }
    }
}

