/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.internal.text.table.TextTableCellReference;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaExpression;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaModel;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.ITextTableCellReferencesService;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;

public class TextTableCellReferencesService
implements ITextTableCellReferencesService {
    protected TextTableFormulaExpression textTableFormulaExpression = null;
    protected TextTableFormulaModel textTableFormulaModel = null;

    public TextTableCellReferencesService(TextTableFormulaExpression textTableFormulaExpression) throws IllegalArgumentException {
        if (textTableFormulaExpression == null) {
            throw new IllegalArgumentException("The submitted formula expression is not valid.");
        }
        this.textTableFormulaExpression = textTableFormulaExpression;
        this.textTableFormulaModel = new TextTableFormulaModel(textTableFormulaExpression);
    }

    @Override
    public boolean hasCellReferenceTo(String cellName) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && (value = textTableCellReference.containsCell(cellName))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasColumnReferenceTo(int columnIndex) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && (value = textTableCellReference.containsColumn(columnIndex))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasColumnReferenceAfter(int columnIndex) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && (value = textTableCellReference.containsColumnAfter(columnIndex))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasRowReferenceTo(int rowIndex) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && (value = textTableCellReference.containsRow(rowIndex))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasRowReferenceAfter(int rowIndex) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && (value = textTableCellReference.containsRowAfter(rowIndex))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void moveColumnReferences(int columnCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified()) {
                textTableCellReference.moveColumnIndex(columnCount);
            }
            ++i;
        }
    }

    @Override
    public void moveColumnReferences(String cellName, int columnCount) throws TextException {
        this.moveColumnReferences(TextTableCellNameHelper.getColumnIndex(cellName), columnCount);
    }

    @Override
    public void moveColumnReferences(int columnIndex, int columnCount) throws TextException {
        this.moveColumnReferences(columnIndex, columnCount, new int[0]);
    }

    @Override
    public void moveColumnReferences(int columnIndex, int columnCount, int[] exceptRows) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsColumn(columnIndex)) {
                boolean except = false;
                int j = 0;
                while (j < exceptRows.length) {
                    if (textTableCellReference.containsRow(exceptRows[j])) {
                        except = true;
                        break;
                    }
                    ++j;
                }
                if (!except) {
                    textTableCellReference.moveColumnIndex(columnCount);
                }
            }
            ++i;
        }
    }

    @Override
    public void moveRowReferences(int rowCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified()) {
                textTableCellReference.moveRowIndex(rowCount);
            }
            ++i;
        }
    }

    @Override
    public void moveRowReferences(String cellName, int rowCount) throws TextException {
        this.moveRowReferences(TextTableCellNameHelper.getRowIndex(cellName), rowCount);
    }

    @Override
    public void moveRowReferences(int rowIndex, int rowCount) throws TextException {
        this.moveRowReferences(rowIndex, rowCount, new int[0]);
    }

    @Override
    public void moveRowReferences(int rowIndex, int rowCount, int[] exceptCols) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsRow(rowIndex)) {
                boolean except = false;
                int j = 0;
                while (j < exceptCols.length) {
                    if (textTableCellReference.containsColumn(exceptCols[j])) {
                        except = true;
                        break;
                    }
                    ++j;
                }
                if (!except) {
                    textTableCellReference.moveRowIndex(rowCount);
                }
            }
            ++i;
        }
    }

    @Override
    public void moveColumnReferencesAfter(int columnIndex, int columnCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsColumnAfter(columnIndex)) {
                textTableCellReference.moveColumnIndex(columnCount);
            }
            ++i;
        }
    }

    @Override
    public void moveRowReferencesAfter(int rowIndex, int rowCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsRowAfter(rowIndex)) {
                textTableCellReference.moveRowIndex(rowCount);
            }
            ++i;
        }
    }

    @Override
    public void extendColumnReferences(String cellName, int columnCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsColumn(cellName)) {
                textTableCellReference.extendColumnRange(columnCount);
            }
            ++i;
        }
    }

    @Override
    public void extendColumnReferences(int columnIndex, int columnCount) throws TextException {
        this.extendColumnReferences(columnIndex, columnCount, new int[0]);
    }

    @Override
    public void extendColumnReferences(int columnIndex, int columnCount, int[] exceptRows) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsColumn(columnIndex)) {
                boolean except = false;
                int j = 0;
                while (j < exceptRows.length) {
                    if (textTableCellReference.containsRow(exceptRows[j])) {
                        except = true;
                        break;
                    }
                    ++j;
                }
                if (!except) {
                    textTableCellReference.extendColumnRange(columnCount);
                }
            }
            ++i;
        }
    }

    @Override
    public void extendRowReferences(String cellName, int rowCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsRow(cellName)) {
                textTableCellReference.extendRowRange(rowCount);
            }
            ++i;
        }
    }

    @Override
    public void extendRowReferences(int rowIndex, int rowCount) throws TextException {
        this.extendRowReferences(rowIndex, rowCount, new int[0]);
    }

    @Override
    public void extendRowReferences(int rowIndex, int rowCount, int[] exceptCols) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsRow(rowIndex)) {
                boolean except = false;
                int j = 0;
                while (j < exceptCols.length) {
                    if (textTableCellReference.containsColumn(exceptCols[j])) {
                        except = true;
                        break;
                    }
                    ++j;
                }
                if (!except) {
                    textTableCellReference.extendRowRange(rowCount);
                }
            }
            ++i;
        }
    }

    @Override
    public void extendRowReferencesTo(int rowIndex, int rowIndexTo) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsRow(rowIndex)) {
                textTableCellReference.extendRowRangeTo(rowIndexTo);
            }
            ++i;
        }
    }

    @Override
    public void extendRowReferences(int rowIndex, int[] rowIndicesTo) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsRow(rowIndex) && !textTableCellReference.isRangeReference()) {
                String startColumnCharacter = textTableCellReference.getStartColumnCharacter();
                TextTableCellReference[] tmpTextTableCellReferences = new TextTableCellReference[rowIndicesTo.length];
                int j = 0;
                while (j < rowIndicesTo.length) {
                    tmpTextTableCellReferences[j] = new TextTableCellReference(String.valueOf(startColumnCharacter) + (rowIndicesTo[j] + 1));
                    ++j;
                }
                this.textTableFormulaModel.replaceCellReference(textTableCellReference, tmpTextTableCellReferences);
            }
            ++i;
        }
    }

    @Override
    public void revertModelToOriginal() {
        this.textTableFormulaModel.revertToOriginal();
    }

    @Override
    public void extendColumnAndRowReferences(String cellName, int columnCount, int rowCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (!textTableCellReference.isModified() && textTableCellReference.containsCell(cellName)) {
                textTableCellReference.extendColumnRange(columnCount);
                textTableCellReference.extendRowRange(rowCount);
            }
            ++i;
        }
    }

    @Override
    public void modifyCellReferences(int newColumnsStartIndex, int newColumnsCount, int newRowsStartIndex, int newRowsCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        int i = 0;
        while (i < textTableCellReferences.length) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.containsColumn(newColumnsStartIndex - 1)) {
                textTableCellReference.extendColumnRange(newColumnsCount);
            } else if (textTableCellReference.containsColumnAfter(newColumnsStartIndex - 1)) {
                textTableCellReference.moveColumnIndex(newColumnsCount);
            }
            if (textTableCellReference.containsRow(newRowsStartIndex - 1)) {
                textTableCellReference.extendRowRange(newRowsCount);
            } else if (textTableCellReference.containsRowAfter(newRowsStartIndex - 1)) {
                textTableCellReference.moveRowIndex(newRowsCount);
            }
            ++i;
        }
    }

    @Override
    public void applyModifications() throws TextException {
        this.textTableFormulaExpression.setExpression(this.textTableFormulaModel.getExpression());
    }
}

