/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;

public class TextTableCellReference {
    private static final char RANGE_DELIMITER = ':';
    private static final char START_REFERENCE = '<';
    private static final char END_REFERENCE = '>';
    private static final char TABLE_DELIMITER = '.';
    private String startCellReference = null;
    private String endCellReference = null;
    private String tableName = null;
    private boolean modified = false;

    public TextTableCellReference(String cellReferenceExpression) throws IllegalArgumentException {
        char character;
        int pointIndex;
        if (cellReferenceExpression == null) {
            throw new IllegalArgumentException("The submitted cell reference is not valid.");
        }
        this.startCellReference = cellReferenceExpression;
        int index = -1;
        index = cellReferenceExpression.indexOf(58);
        if (index != -1) {
            this.startCellReference = cellReferenceExpression.substring(0, index);
            this.endCellReference = cellReferenceExpression.substring(index + 1);
        }
        if (this.startCellReference.startsWith(String.valueOf('<'))) {
            this.startCellReference = this.endCellReference == null ? this.startCellReference.substring(1, this.startCellReference.length() - 1) : this.startCellReference.substring(1, this.startCellReference.length());
        }
        if (this.endCellReference != null && this.endCellReference.endsWith(String.valueOf('>'))) {
            this.endCellReference = this.endCellReference.substring(0, this.endCellReference.length() - 1);
        }
        if ((pointIndex = this.startCellReference.indexOf(46)) != -1 && Character.isLetter(character = this.startCellReference.charAt(pointIndex + 1))) {
            this.tableName = this.startCellReference.substring(0, pointIndex);
            this.startCellReference = this.startCellReference.substring(pointIndex + 1, this.startCellReference.length());
        }
        this.init();
    }

    private void init() {
    }

    public boolean isRangeReference() {
        return this.endCellReference != null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean containsCell(String cellName) {
        int columnIndex = TextTableCellNameHelper.getColumnIndex(cellName);
        int rowIndex = TextTableCellNameHelper.getRowIndex(cellName);
        return this.containsCell(columnIndex, rowIndex);
    }

    public boolean containsCell(int columnIndex, int rowIndex) {
        int startRowIndex = this.getStartRowIndex();
        int startColumnIndex = this.getStartColumnIndex();
        int endRowIndex = this.getEndRowIndex();
        int endColumnIndex = this.getEndColumnIndex();
        return rowIndex >= startRowIndex && rowIndex <= endRowIndex && columnIndex >= startColumnIndex && columnIndex <= endColumnIndex;
    }

    public boolean containsColumn(String cellName) {
        int columnIndex = TextTableCellNameHelper.getColumnIndex(cellName);
        return this.containsColumn(columnIndex);
    }

    public boolean containsColumn(int columnIndex) {
        int startColumnIndex = this.getStartColumnIndex();
        int endColumnIndex = this.getEndColumnIndex();
        return columnIndex >= startColumnIndex && columnIndex <= endColumnIndex;
    }

    public boolean containsRow(String cellName) {
        int rowIndex = TextTableCellNameHelper.getRowIndex(cellName);
        return this.containsRow(rowIndex);
    }

    public boolean containsRow(int rowIndex) {
        int startRowIndex = this.getStartRowIndex();
        int endRowIndex = this.getEndRowIndex();
        return rowIndex >= startRowIndex && rowIndex <= endRowIndex;
    }

    public boolean containsColumnAfter(String cellName) {
        int columnIndex = TextTableCellNameHelper.getColumnIndex(cellName);
        return this.containsColumnAfter(columnIndex);
    }

    public boolean containsColumnAfter(int columnIndex) {
        int endColumnIndex = this.getEndColumnIndex();
        return endColumnIndex >= columnIndex;
    }

    public boolean containsRowAfter(String cellName) {
        int rowIndex = TextTableCellNameHelper.getRowIndex(cellName);
        return this.containsRowAfter(rowIndex);
    }

    public boolean containsRowAfter(int rowIndex) {
        int endRowIndex = this.getEndRowIndex();
        return endRowIndex >= rowIndex;
    }

    public int getStartColumnIndex() {
        return TextTableCellNameHelper.getColumnIndex(this.startCellReference);
    }

    public String getStartColumnCharacter() {
        return TextTableCellNameHelper.getColumnCharacter(this.startCellReference);
    }

    public int getEndColumnIndex() {
        if (this.endCellReference == null) {
            return this.getStartColumnIndex();
        }
        return TextTableCellNameHelper.getColumnIndex(this.endCellReference);
    }

    public int getStartRowIndex() {
        return TextTableCellNameHelper.getRowIndex(this.startCellReference);
    }

    public int getEndRowIndex() {
        if (this.endCellReference == null) {
            return this.getStartRowIndex();
        }
        return TextTableCellNameHelper.getRowIndex(this.endCellReference);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.modified = true;
    }

    public void moveColumnIndex(int count) throws TextException {
        this.startCellReference = TextTableCellNameHelper.moveColumnIndex(count, this.startCellReference);
        if (this.endCellReference != null) {
            this.endCellReference = TextTableCellNameHelper.moveColumnIndex(count, this.endCellReference);
        }
        this.modified = true;
    }

    public void moveRowIndex(int count) throws TextException {
        this.startCellReference = TextTableCellNameHelper.moveRowCounterValue(count, this.startCellReference);
        if (this.endCellReference != null) {
            this.endCellReference = TextTableCellNameHelper.moveRowCounterValue(count, this.endCellReference);
        }
        this.modified = true;
    }

    public void toColumnRange(int startColumnIndex, int endColumnIndex) throws TextException {
        this.startCellReference = TextTableCellNameHelper.moveColumnIndexTo(startColumnIndex, this.startCellReference);
        this.endCellReference = TextTableCellNameHelper.moveColumnIndexTo(endColumnIndex, this.startCellReference);
        this.modified = true;
    }

    public void extendColumnRangeTo(int endColumnIndex) throws TextException {
        if (endColumnIndex < TextTableCellNameHelper.getColumnIndex(this.startCellReference)) {
            return;
        }
        if (this.endCellReference == null) {
            this.endCellReference = TextTableCellNameHelper.moveColumnIndexTo(endColumnIndex, this.startCellReference);
        } else if (TextTableCellNameHelper.getColumnIndex(this.endCellReference) < endColumnIndex) {
            this.endCellReference = TextTableCellNameHelper.moveColumnIndexTo(endColumnIndex, this.endCellReference);
        }
        this.modified = true;
    }

    public void extendColumnRange(int count) throws TextException {
        if (count < 1) {
            return;
        }
        this.endCellReference = this.endCellReference == null ? TextTableCellNameHelper.moveColumnIndex(count, this.startCellReference) : TextTableCellNameHelper.moveColumnIndex(count, this.endCellReference);
        this.modified = true;
    }

    public void extendRowRangeTo(int rowIndexTo) throws TextException {
        if (rowIndexTo <= this.getStartRowIndex()) {
            this.endCellReference = null;
            return;
        }
        this.endCellReference = this.endCellReference == null ? TextTableCellNameHelper.moveRowCounterValueTo(rowIndexTo + 1, this.startCellReference) : TextTableCellNameHelper.moveRowCounterValueTo(rowIndexTo + 1, this.endCellReference);
        this.modified = true;
    }

    public void extendRowRange(int count) throws TextException {
        if (count < 1) {
            return;
        }
        this.endCellReference = this.endCellReference == null ? TextTableCellNameHelper.moveRowCounterValue(count, this.startCellReference) : TextTableCellNameHelper.moveRowCounterValue(count, this.endCellReference);
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String toString() {
        this.modified = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        if (this.tableName != null) {
            stringBuffer.append(this.tableName).append('.');
        }
        if (this.endCellReference == null) {
            return stringBuffer.append(this.startCellReference).append('>').toString();
        }
        return stringBuffer.append(this.startCellReference).append(':').append(this.endCellReference).append('>').toString();
    }
}

