/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.text.table.ITextTableCellRangeName;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;

public class TextTableCellRangeName
implements ITextTableCellRangeName {
    private String rangeName = null;
    private int startColumnIndex = -1;
    private int endColumnIndex = -1;
    private int startRowIndex = -1;
    private int endRowIndex = -1;

    public TextTableCellRangeName(String rangeName) {
        this.rangeName = rangeName;
        this.startColumnIndex = TextTableCellNameHelper.getCellRangeStartColumnIndex(rangeName);
        this.startRowIndex = TextTableCellNameHelper.getCellRangeStartRowIndex(rangeName);
        this.endColumnIndex = TextTableCellNameHelper.getCellRangeEndColumnIndex(rangeName);
        this.endRowIndex = TextTableCellNameHelper.getCellRangeEndRowIndex(rangeName);
    }

    public TextTableCellRangeName(int startColumnIndex, int startRowIndex, int endColumnIndex, int endRowIndex) {
        this.startColumnIndex = startColumnIndex;
        this.startRowIndex = startRowIndex;
        this.endColumnIndex = endColumnIndex;
        this.endRowIndex = endRowIndex;
        this.rangeName = TextTableCellNameHelper.getRangeName(startColumnIndex, startRowIndex, endColumnIndex, endRowIndex);
    }

    @Override
    public String getRangeName() {
        return this.rangeName;
    }

    @Override
    public int getRangeStartColumnIndex() {
        return this.startColumnIndex;
    }

    @Override
    public int getRangeStartRowIndex() {
        return this.startRowIndex;
    }

    @Override
    public int getRangeEndColumnIndex() {
        return this.endColumnIndex;
    }

    @Override
    public int getRangeEndRowIndex() {
        return this.endRowIndex;
    }
}

