/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.LineCursor;
import ag.ion.bion.officelayer.internal.text.PageCursor;
import ag.ion.bion.officelayer.internal.text.TextCursor;
import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.text.ILineCursor;
import ag.ion.bion.officelayer.text.IPageCursor;
import ag.ion.bion.officelayer.text.ITextCursor;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.IViewCursor;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XLineCursor;

public class ViewCursor
implements IViewCursor {
    private ITextDocument textDocument = null;
    private IPageCursor pageCursor = null;
    private ILineCursor lineCursor = null;
    private XTextViewCursor xTextViewCursor = null;

    public ViewCursor(ITextDocument textDocument, XTextViewCursor xTextViewCursor) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        this.textDocument = textDocument;
        if (xTextViewCursor == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XTextViewCursor interface is not valid.");
        }
        this.xTextViewCursor = xTextViewCursor;
    }

    @Override
    public ITextRange getStartTextRange() {
        return new TextRange(this.textDocument, this.xTextViewCursor.getStart());
    }

    @Override
    public ITextCursor getTextCursorFromStart() {
        XTextCursor xTextCursor = this.xTextViewCursor.getText().createTextCursorByRange(this.xTextViewCursor.getStart());
        return new TextCursor(this.textDocument, xTextCursor);
    }

    @Override
    public ITextCursor getTextCursorFromEnd() {
        XTextCursor xTextCursor = this.xTextViewCursor.getText().createTextCursorByRange(this.xTextViewCursor.getEnd());
        return new TextCursor(this.textDocument, xTextCursor);
    }

    @Override
    public void goToRange(ITextRange textRange, boolean select) {
        XTextRange xTextRange = textRange.getXTextRange();
        this.xTextViewCursor.gotoRange(xTextRange, select);
    }

    @Override
    public IPageCursor getPageCursor() {
        XPageCursor xPageCursor;
        if (this.pageCursor == null && (xPageCursor = (XPageCursor)UnoRuntime.queryInterface(XPageCursor.class, (Object)this.xTextViewCursor)) != null) {
            this.pageCursor = new PageCursor(xPageCursor);
        }
        return this.pageCursor;
    }

    @Override
    public ILineCursor getLineCursor() {
        XLineCursor xLineCursor;
        if (this.lineCursor == null && (xLineCursor = (XLineCursor)UnoRuntime.queryInterface(XLineCursor.class, (Object)this.xTextViewCursor)) != null) {
            this.lineCursor = new LineCursor(xLineCursor);
        }
        return this.lineCursor;
    }
}

