/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.internal.text.TextTableCellRange;
import ag.ion.bion.officelayer.internal.text.table.TextTableRowCloneService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.ITextTableRow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.table.XTableRows;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.UnoRuntime;

public class TextTableRow
implements ITextTableRow {
    private ITextDocument textDocument = null;
    private TextTableCellRange textTableCellRange = null;

    public TextTableRow(TextTableCellRange textTableCellRange) throws IllegalArgumentException {
        if (textTableCellRange == null) {
            throw new IllegalArgumentException("Submitted range is not valid.");
        }
        this.textDocument = textTableCellRange.getTextDocument();
        this.textTableCellRange = textTableCellRange;
    }

    public ITextDocument getTextDocument() {
        return this.textDocument;
    }

    @Override
    public ITextTableCell[] getCells() {
        ITextTableCell[] textTableCells = this.textTableCellRange.getCells()[0];
        return textTableCells;
    }

    @Override
    public ICloneService getCloneService() throws CloneException {
        return new TextTableRowCloneService(this);
    }

    @Override
    public ITextTableCellRange getCellRange() {
        return this.textTableCellRange;
    }

    @Override
    public int getHeight() {
        if (this.textTableCellRange == null) {
            return 0;
        }
        try {
            XTextTable xTextTable = (XTextTable)this.textTableCellRange.getCell(0, 0).getTextTable().getXTextContent();
            XTableRows tableRows = xTextTable.getRows();
            Object row = tableRows.getByIndex(this.textTableCellRange.getRangeName().getRangeStartRowIndex());
            XPropertySet propertySetRow = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)row);
            Integer rowHeight = (Integer)propertySetRow.getPropertyValue("Height");
            return rowHeight;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void setHeight(int height) {
        if (this.textTableCellRange == null) {
            return;
        }
        try {
            XTextTable xTextTable = (XTextTable)this.textTableCellRange.getCell(0, 0).getTextTable().getXTextContent();
            XTableRows tableRows = xTextTable.getRows();
            Object row = tableRows.getByIndex(this.textTableCellRange.getRangeName().getRangeStartRowIndex());
            XPropertySet propertySetRow = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)row);
            propertySetRow.setPropertyValue("Height", (Object)new Integer(height));
        }
        catch (Exception exception) {}
    }

    @Override
    public boolean getAutoHeight() {
        if (this.textTableCellRange == null) {
            return false;
        }
        try {
            XTextTable xTextTable = (XTextTable)this.textTableCellRange.getCell(0, 0).getTextTable().getXTextContent();
            XTableRows tableRows = xTextTable.getRows();
            int rowIndex = this.textTableCellRange.getRangeName().getRangeStartRowIndex();
            Object row = tableRows.getByIndex(rowIndex);
            XPropertySet propertySetRow = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)row);
            Boolean rowAutoHeight = (Boolean)propertySetRow.getPropertyValue("IsAutoHeight");
            return rowAutoHeight;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void setAutoHeight(boolean autoHeight) {
        if (this.textTableCellRange == null) {
            return;
        }
        try {
            XTextTable xTextTable = (XTextTable)this.textTableCellRange.getCell(0, 0).getTextTable().getXTextContent();
            XTableRows tableRows = xTextTable.getRows();
            Object row = tableRows.getByIndex(this.textTableCellRange.getRangeName().getRangeStartRowIndex());
            XPropertySet propertySetRow = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)row);
            propertySetRow.setPropertyValue("IsAutoHeight", (Object)new Boolean(autoHeight));
        }
        catch (Exception exception) {}
    }
}

