/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.internal.text.TextTableColumnsSeparator;
import ag.ion.bion.officelayer.internal.text.table.TextTableColumnCloneService;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.ITextTableColumn;
import ag.ion.bion.officelayer.text.ITextTableProperties;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;

public class TextTableColumn
implements ITextTableColumn {
    private static final int MIN_COLUMN_WIDTH = 50;
    private ITextTableCellRange textTableCellRange = null;
    private ITextTable textTable = null;
    private int index = 0;

    public TextTableColumn(ITextTable textTable, int index) throws IllegalArgumentException, TextException {
        if (textTable == null) {
            throw new IllegalArgumentException("Submitted textTable is not valid.");
        }
        this.textTable = textTable;
        if (index < 0) {
            throw new IllegalArgumentException("Submitted index is not valid.");
        }
        String[] cellNames = textTable.getXTextTable().getCellNames();
        String oldCellName = null;
        String cellRange = null;
        int i = 0;
        while (i < cellNames.length) {
            if (TextTableCellNameHelper.getColumnIndex(cellNames[i]) == index) {
                if (cellRange == null) {
                    cellRange = cellNames[i];
                }
                oldCellName = cellNames[i];
            }
            ++i;
        }
        if (!cellRange.equals(oldCellName)) {
            cellRange = String.valueOf(cellRange) + ":" + oldCellName;
        }
        this.textTableCellRange = textTable.getCellRange(cellRange);
        this.index = index;
    }

    @Override
    public void setWidth(short width) throws TextException {
        ITextTableProperties textTableProperties = this.textTable.getProperties();
        TextTableColumnsSeparator[] textTableColumnsSeparators = textTableProperties.getTableColumnSeparators();
        int columnsSeparatorsLength = textTableColumnsSeparators.length;
        long textTableWidth = textTableProperties.getWidth();
        if (columnsSeparatorsLength > 0 && this.index <= columnsSeparatorsLength) {
            if (this.index == 0) {
                if (columnsSeparatorsLength == 1) {
                    if ((long)width < textTableWidth - 50L) {
                        textTableColumnsSeparators[this.index].setPosition(width);
                    } else {
                        textTableColumnsSeparators[this.index].setPosition((short)(textTableWidth - 50L));
                    }
                } else if (width < textTableColumnsSeparators[this.index + 1].getPosition() - 50) {
                    textTableColumnsSeparators[this.index].setPosition(width);
                } else {
                    textTableColumnsSeparators[this.index].setPosition((short)(textTableColumnsSeparators[this.index + 1].getPosition() - 50));
                }
            } else if (this.index < columnsSeparatorsLength) {
                if (this.index == columnsSeparatorsLength - 1) {
                    if ((long)(textTableColumnsSeparators[this.index - 1].getPosition() + width) < textTableWidth - 50L) {
                        textTableColumnsSeparators[this.index].setPosition((short)(textTableColumnsSeparators[this.index - 1].getPosition() + width));
                    } else {
                        textTableColumnsSeparators[this.index].setPosition((short)(textTableWidth - 50L));
                    }
                } else if (textTableColumnsSeparators[this.index - 1].getPosition() + width < textTableColumnsSeparators[this.index + 1].getPosition() - 50) {
                    textTableColumnsSeparators[this.index].setPosition((short)(textTableColumnsSeparators[this.index - 1].getPosition() + width));
                } else {
                    textTableColumnsSeparators[this.index].setPosition((short)(textTableColumnsSeparators[this.index + 1].getPosition() - 50));
                }
            } else if (columnsSeparatorsLength == 1) {
                if (textTableWidth - (long)width > 50L) {
                    textTableColumnsSeparators[this.index - 1].setPosition((short)(textTableWidth - (long)width));
                } else {
                    textTableColumnsSeparators[this.index - 1].setPosition((short)50);
                }
            } else if (textTableWidth - (long)width > (long)(textTableColumnsSeparators[this.index - 2].getPosition() + 50)) {
                textTableColumnsSeparators[this.index - 1].setPosition((short)(textTableWidth - (long)width));
            } else {
                textTableColumnsSeparators[this.index - 1].setPosition((short)(textTableColumnsSeparators[this.index - 2].getPosition() + 50));
            }
        }
        textTableProperties.setTableColumnSeparators(textTableColumnsSeparators);
    }

    @Override
    public short getWidth() throws TextException {
        ITextTableProperties textTableProperties = this.textTable.getProperties();
        TextTableColumnsSeparator[] textTableColumnsSeparators = textTableProperties.getTableColumnSeparators();
        int columnsSeparatorsLength = textTableColumnsSeparators.length;
        if (this.index <= columnsSeparatorsLength) {
            if (this.index == 0) {
                return textTableColumnsSeparators[this.index].getPosition();
            }
            if (this.index < columnsSeparatorsLength) {
                return (short)(textTableColumnsSeparators[this.index].getPosition() - textTableColumnsSeparators[this.index - 1].getPosition());
            }
            return (short)(textTableProperties.getWidth() - (long)textTableColumnsSeparators[this.index - 1].getPosition());
        }
        return 0;
    }

    @Override
    public ITextTableCellRange getCellRange() {
        return this.textTableCellRange;
    }

    @Override
    public ICloneService getCloneService() throws CloneException {
        return new TextTableColumnCloneService(this);
    }
}

