/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.internal.text.TextTableCell;
import ag.ion.bion.officelayer.internal.text.TextTableCellProperties;
import ag.ion.bion.officelayer.internal.text.table.TextTableCellRangeCloneService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellProperties;
import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.ITextTableCellRangeName;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.UnoRuntime;

public class TextTableCellRange
implements ITextTableCellRange {
    private ITextDocument textDocument = null;
    private ITextTableCellRangeName textTableCellRangeName = null;
    private XCellRange xCellRange = null;

    public TextTableCellRange(ITextDocument textDocument, XCellRange xCellRange, ITextTableCellRangeName textTableCellRangeName) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        if (xCellRange == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XCellRange interface is not valid.");
        }
        if (textTableCellRangeName == null) {
            throw new IllegalArgumentException("Submitted text table range name is not valid.");
        }
        if (textTableCellRangeName.getRangeStartColumnIndex() > 52) {
            throw new IllegalArgumentException("The submitted range is not valid");
        }
        this.textDocument = textDocument;
        this.xCellRange = xCellRange;
        this.textTableCellRangeName = textTableCellRangeName;
    }

    @Override
    public XCellRange getXCellRange() {
        return this.xCellRange;
    }

    @Override
    public ITextDocument getTextDocument() {
        return this.textDocument;
    }

    @Override
    public void setData(Object[][] values) throws TextException {
        try {
            XCellRangeData xCellRangeData = (XCellRangeData)UnoRuntime.queryInterface(XCellRangeData.class, (Object)this.xCellRange);
            xCellRangeData.setDataArray(values);
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public Object[][] getData() {
        XCellRangeData xCellRangeData = (XCellRangeData)UnoRuntime.queryInterface(XCellRangeData.class, (Object)this.xCellRange);
        return xCellRangeData.getDataArray();
    }

    @Override
    public ITextTableCellProperties getCellProperties() {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xCellRange);
        return new TextTableCellProperties(xPropertySet);
    }

    @Override
    public int getRowCount() {
        return this.textTableCellRangeName.getRangeEndRowIndex() + 1 - this.textTableCellRangeName.getRangeStartRowIndex();
    }

    @Override
    public int getColumnCount() {
        return this.textTableCellRangeName.getRangeEndColumnIndex() + 1 - this.textTableCellRangeName.getRangeStartColumnIndex();
    }

    @Override
    public ITextTableCell getCell(String name) throws TextException {
        int columnIndex = TextTableCellNameHelper.getColumnIndex(name);
        int rowIndex = TextTableCellNameHelper.getRowIndex(name);
        try {
            return new TextTableCell(this.textDocument, this.xCellRange.getCellByPosition(columnIndex, rowIndex));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TextException("A column with the name " + name + " is not available.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new TextException("A column with the name " + name + " is not available.");
        }
    }

    @Override
    public ITextTableCell getCell(int columnIndex, int rowIndex) throws TextException {
        String columnCharacters = TextTableCellNameHelper.getColumnCharacter(columnIndex);
        int rowCounter = TextTableCellNameHelper.getRowCounterValue(rowIndex);
        return this.getCell(String.valueOf(columnCharacters) + rowCounter);
    }

    @Override
    public ITextTableCellRangeName getRangeName() {
        return this.textTableCellRangeName;
    }

    @Override
    public ITextTableCell[][] getCells() {
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        ITextTableCell[][] textTableCells = new ITextTableCell[rowCount][columnCount];
        try {
            int i = 0;
            while (i < rowCount) {
                ITextTableCell[] currentRow = new ITextTableCell[columnCount];
                int j = 0;
                while (j < columnCount) {
                    XCell xCell = this.xCellRange.getCellByPosition(j, i);
                    currentRow[j] = new TextTableCell(this.textDocument, xCell);
                    ++j;
                }
                textTableCells[i] = currentRow;
                ++i;
            }
        }
        catch (Exception exception) {}
        return textTableCells;
    }

    @Override
    public ICloneService getCloneService() throws CloneException {
        return new TextTableCellRangeCloneService(this);
    }
}

