/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.internal.text.TextTableCell;
import ag.ion.bion.officelayer.internal.text.TextTableCellRange;
import ag.ion.bion.officelayer.internal.text.TextTableColumn;
import ag.ion.bion.officelayer.internal.text.TextTableProperties;
import ag.ion.bion.officelayer.internal.text.TextTableRow;
import ag.ion.bion.officelayer.internal.text.table.TextTableCellRangeName;
import ag.ion.bion.officelayer.internal.text.table.TextTableCloneService;
import ag.ion.bion.officelayer.internal.text.table.TextTablePropertyStore;
import ag.ion.bion.officelayer.text.AbstractTextComponent;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.ITextTableColumn;
import ag.ion.bion.officelayer.text.ITextTableProperties;
import ag.ion.bion.officelayer.text.ITextTableRow;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.IFormula;
import ag.ion.bion.officelayer.text.table.IFormulaService;
import ag.ion.bion.officelayer.text.table.ITextTableCellRangeName;
import ag.ion.bion.officelayer.text.table.ITextTablePropertyStore;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;
import ag.ion.noa.text.XInterfaceObjectSelection;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTableCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.util.ArrayList;
import java.util.List;

public class TextTable
extends AbstractTextComponent
implements ITextTable {
    private XTextTable xTextTable = null;
    private XCellRange xCellRange = null;
    private List formulaCells = null;

    public TextTable(ITextDocument textDocument, XTextTable xTextTable) throws IllegalArgumentException {
        super(textDocument);
        if (xTextTable == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XTextTable interface is not valid.");
        }
        this.xTextTable = xTextTable;
    }

    @Override
    public XTextContent getXTextContent() {
        return this.xTextTable;
    }

    @Override
    public XTextTable getXTextTable() {
        return this.xTextTable;
    }

    @Override
    public ITextRange getTextRange() throws Exception {
        XTextContent textContent = this.getXTextContent();
        this.textDocument.setSelection(new XInterfaceObjectSelection((XInterface)textContent));
        XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)this.textDocument.getXTextDocument().getCurrentController());
        xTextViewCursorSupplier.getViewCursor().goLeft((short)1, false);
        return this.textDocument.getViewCursorService().getViewCursor().getTextCursorFromEnd().getEnd();
    }

    @Override
    public ITextTableProperties getProperties() {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xTextTable);
        return new TextTableProperties(xPropertySet);
    }

    @Override
    public String getName() {
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)this.xTextTable);
        return xNamed.getName();
    }

    public void setCellData(String cellName, XTextContent xTextContent) throws Exception {
        XCell xCell = this.xTextTable.getCellByName(cellName);
        XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xCell);
        xText.setString("");
        xText.insertTextContent(xText.getStart(), xTextContent, true);
    }

    public void addCellData(String cellName, XTextContent xTextContent) throws Exception {
        XCell xCell = this.xTextTable.getCellByName(cellName);
        XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xCell);
        xText.insertTextContent(xText.getEnd(), xTextContent, true);
    }

    public void setCellData(String cellName, String content) throws Exception {
        XCell xCell = this.xTextTable.getCellByName(cellName);
        XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xCell);
        xText.setString(content);
    }

    public void addCellData(String cellName, String content) throws Exception {
        XCell xCell = this.xTextTable.getCellByName(cellName);
        XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xCell);
        xText.getEnd().setString(content);
    }

    public void setCellData(String cellName, double content) throws Exception {
        XCell xCell = this.xTextTable.getCellByName(cellName);
        xCell.setValue(content);
    }

    public void setCellFormula(String cellName, String formula) throws Exception {
        XCell xCell = this.xTextTable.getCellByName(cellName);
        xCell.setFormula(formula);
    }

    @Override
    public void addRow(int count) throws TextException {
        if (count > 0) {
            this.xTextTable.getRows().insertByIndex(this.getRowCount(), count);
        }
    }

    @Override
    public void addRow(int index, int count) throws TextException {
        if (index > -1 && count > 0) {
            this.xTextTable.getRows().insertByIndex(index, count);
        }
    }

    @Override
    public int getRowCount() {
        String[] cellNames = this.xTextTable.getCellNames();
        int rows = 0;
        int i = 0;
        while (i < cellNames.length) {
            int row = TextTableCellNameHelper.getRowIndex(cellNames[i]);
            if (++row > rows) {
                rows = row;
            }
            ++i;
        }
        return rows;
    }

    @Override
    public void addColumn(int count) throws TextException {
        if (count > 0) {
            this.xTextTable.getColumns().insertByIndex(this.getColumnCount(), count);
        }
    }

    @Override
    public void addColumn(int index, int count) throws TextException {
        if (index > -1 && count > 0) {
            this.xTextTable.getColumns().insertByIndex(index, count);
        }
    }

    @Override
    public void addColumn(int index, int count, boolean after) throws TextException {
        if (index > -1 && count > 0) {
            if (after) {
                this.xTextTable.getColumns().insertByIndex(index, count);
            } else {
                this.xTextTable.getColumns().insertByIndex(index - 1, count);
            }
        }
    }

    @Override
    public ITextTableColumn getColumn(int index) throws TextException {
        return this.getColumns()[index];
    }

    @Override
    public ITextTableColumn[] getColumns() throws TextException {
        ITextTableColumn[] textTableColumns = new TextTableColumn[this.getColumnCount()];
        int i = 0;
        while (i < textTableColumns.length) {
            textTableColumns[i] = new TextTableColumn(this, i);
            ++i;
        }
        return textTableColumns;
    }

    @Override
    public int getColumnCount() {
        String[] cellNames = this.xTextTable.getCellNames();
        int cols = 0;
        int i = 0;
        while (i < cellNames.length) {
            int col = TextTableCellNameHelper.getColumnIndex(cellNames[i]);
            if (++col > cols) {
                cols = col;
            }
            ++i;
        }
        return cols;
    }

    @Override
    public void spreadColumnsEvenly() throws TextException {
        this.spreadColumnsEvenly(0, this.getColumnCount() - 1);
    }

    @Override
    public void spreadColumnsEvenly(int startIndex, int endIndex) throws TextException {
        if (endIndex > startIndex && startIndex > -1) {
            long tableWidth = this.getProperties().getWidth();
            long rangeWidth = 0L;
            TextTableColumn textTableColumn = null;
            int i = startIndex;
            while (i <= endIndex) {
                textTableColumn = new TextTableColumn(this, i);
                rangeWidth += (long)textTableColumn.getWidth();
                ++i;
            }
            long evenColumnWidth = rangeWidth / (long)(endIndex - startIndex + 1);
            int i2 = endIndex - 1;
            while (i2 >= startIndex) {
                textTableColumn = new TextTableColumn(this, i2);
                textTableColumn.setWidth((short)tableWidth);
                --i2;
            }
            i2 = startIndex;
            while (i2 <= endIndex) {
                textTableColumn = new TextTableColumn(this, i2);
                textTableColumn.setWidth((short)evenColumnWidth);
                ++i2;
            }
        }
    }

    @Override
    public ITextTableCell getCell(String name) throws TextException {
        try {
            XCell xCell = this.xTextTable.getCellByName(name);
            if (xCell != null) {
                return new TextTableCell(this.textDocument, xCell);
            }
            throw new TextException("A column with the name " + name + " is not available.");
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public ITextTableCell[] getCellsWithFormula() {
        if (this.formulaCells == null) {
            this.analyseTableFormulas();
        }
        return this.formulaCells.toArray(new ITextTableCell[this.formulaCells.size()]);
    }

    @Override
    public ITextTableCell getCell(int columnIndex, int rowIndex) throws TextException {
        String columnCharacters = TextTableCellNameHelper.getColumnCharacter(columnIndex);
        int rowCounter = TextTableCellNameHelper.getRowCounterValue(rowIndex);
        return this.getCell(String.valueOf(columnCharacters) + rowCounter);
    }

    @Override
    public ITextTableCellRange getCellRange(int firstColumnIndex, int firstRowIndex, int lastColumnIndex, int lastRowIndex) throws TextException {
        String cellRangeName = TextTableCellNameHelper.getRangeName(firstColumnIndex, firstRowIndex, lastColumnIndex, lastRowIndex);
        try {
            if (this.xCellRange == null) {
                this.xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)this.xTextTable);
            }
            XCellRange newXCellRange = this.xCellRange.getCellRangeByPosition(firstColumnIndex, firstRowIndex, lastColumnIndex, lastRowIndex);
            TextTableCellRangeName textTableCellRangeName = new TextTableCellRangeName(cellRangeName);
            TextTableCellRange textTableCellRange = new TextTableCellRange(this.textDocument, newXCellRange, textTableCellRangeName);
            return textTableCellRange;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public ITextTableCellRange getCellRange(String cellRangeName) throws TextException {
        return this.getCellRange(TextTableCellNameHelper.getCellRangeStartColumnIndex(cellRangeName), TextTableCellNameHelper.getCellRangeStartRowIndex(cellRangeName), TextTableCellNameHelper.getCellRangeEndColumnIndex(cellRangeName), TextTableCellNameHelper.getCellRangeEndRowIndex(cellRangeName));
    }

    @Override
    public ITextTableRow[] getRows() {
        String rangeName;
        ITextTableRow[] textTableRow = new ITextTableRow[this.getRowCount()];
        String[] cellNames = this.xTextTable.getCellNames();
        int lastRowIndex = 0;
        String oldCellName = rangeName = "A1";
        if (this.xCellRange == null) {
            this.xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)this.xTextTable);
        }
        int i = 0;
        while (i < cellNames.length) {
            int thisRowIndex = TextTableCellNameHelper.getRowIndex(cellNames[i]);
            if (thisRowIndex != lastRowIndex) {
                rangeName = String.valueOf(rangeName) + ":" + oldCellName;
                TextTableCellRangeName textTableCellRangeName = new TextTableCellRangeName(rangeName);
                TextTableCellRange textTableCellRange = new TextTableCellRange(this.textDocument, this.xCellRange.getCellRangeByName(rangeName), textTableCellRangeName);
                textTableRow[lastRowIndex] = new TextTableRow(textTableCellRange);
                rangeName = cellNames[i];
                lastRowIndex = thisRowIndex;
            }
            oldCellName = cellNames[i];
            ++i;
        }
        rangeName = String.valueOf(rangeName) + ":" + oldCellName;
        TextTableCellRangeName textTableCellRangeName = new TextTableCellRangeName(rangeName);
        TextTableCellRange textTableCellRange = new TextTableCellRange(this.textDocument, this.xCellRange.getCellRangeByName(rangeName), textTableCellRangeName);
        textTableRow[lastRowIndex] = new TextTableRow(textTableCellRange);
        return textTableRow;
    }

    @Override
    public ICloneService getCloneService() throws CloneException {
        return new TextTableCloneService(this, this.textDocument.getXTextDocument());
    }

    @Override
    public ITextTableRow getRow(int index) {
        if (this.xCellRange == null) {
            this.xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)this.xTextTable);
        }
        TextTableRow textTableRow = null;
        try {
            String[] cellNames = this.xTextTable.getCellNames();
            String endCellName = "A" + (index + 1);
            int i = 0;
            while (i < cellNames.length) {
                if (TextTableCellNameHelper.getRowIndex(cellNames[i]) == index) {
                    endCellName = cellNames[i];
                }
                ++i;
            }
            String rangeName = "A" + (index + 1) + ":" + endCellName;
            TextTableCellRangeName textTableCellRangeName = new TextTableCellRangeName(rangeName);
            TextTableCellRange textTableCellRange = new TextTableCellRange(this.textDocument, this.xCellRange.getCellRangeByName(rangeName), textTableCellRangeName);
            textTableRow = new TextTableRow(textTableCellRange);
        }
        catch (Exception exception) {}
        return textTableRow;
    }

    @Override
    public ITextTablePropertyStore getPropertyStore() throws TextException {
        return new TextTablePropertyStore(this);
    }

    @Override
    public void removeRow(int index) throws TextException {
        try {
            this.xTextTable.getRows().removeByIndex(index, 1);
        }
        catch (Exception exception) {
            TextException textException = new TextException("The specified row could not be removed");
            textException.initCause(exception);
        }
    }

    @Override
    public void removeRows(int index, int count) throws TextException {
        try {
            this.xTextTable.getRows().removeByIndex(index, count);
        }
        catch (Exception exception) {
            TextException textException = new TextException("The specified row could not be removed");
            textException.initCause(exception);
        }
    }

    @Override
    public void remove() throws TextException {
        try {
            this.textDocument.getTextService().getTextContentService().removeTextContent(this);
        }
        catch (Exception exception) {
            TextException textException = new TextException("The specified table can not be removed");
            textException.initCause(exception);
        }
    }

    @Override
    public short getTableStartPageNumber() {
        String[] cellNames = this.xTextTable.getCellNames();
        if (cellNames.length < 1) {
            return -1;
        }
        try {
            return this.getCell(cellNames[0]).getPageNumber();
        }
        catch (TextException textException) {
            return -1;
        }
    }

    @Override
    public void setHeaderRows(int headerRows) throws TextException {
        if (headerRows > 0) {
            int rows = this.getRowCount();
            if (headerRows > rows) {
                headerRows = rows;
            }
            String[] cellNames = this.xTextTable.getCellNames();
            int i = 0;
            while (i < cellNames.length) {
                int row = TextTableCellNameHelper.getRowIndex(cellNames[i]);
                if (row < headerRows) {
                    this.getCell(cellNames[i]).setCellParagraphStyle("Table Heading");
                }
                ++i;
            }
        }
    }

    @Override
    public short getTableEndPageNumber() {
        String[] cellNames = this.xTextTable.getCellNames();
        if (cellNames.length < 1) {
            return -1;
        }
        try {
            return this.getCell(cellNames[cellNames.length - 1]).getPageNumber();
        }
        catch (TextException textException) {
            return -1;
        }
    }

    @Override
    public void markTable() {
        try {
            String firstCell = "A1";
            String range = String.valueOf(firstCell) + ":";
            ITextTableRow[] rows = this.getRows();
            if (rows.length > 0) {
                XCell cell;
                XPropertySet xPropertySet;
                ITextTableCell[] cells = rows[rows.length - 1].getCells();
                String lastCellName = cells[cells.length - 1].getName().getName();
                range = String.valueOf(range) + TextTableCellNameHelper.getColumnCharacter(lastCellName) + TextTableCellNameHelper.getRowCounterValue(lastCellName);
                ITextTableCellRange cellRange = this.getCellRange(range);
                ITextDocument textDocument = this.getTextDocument();
                if (textDocument.isOpen() && (xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)(cell = this.getXTextTable().getCellByName(firstCell)))) != null) {
                    XPropertySet xTextSectionPropertySet;
                    Object value = xPropertySet.getPropertyValue("TextSection");
                    boolean select = true;
                    XTextSection xTextSection = (XTextSection)UnoRuntime.queryInterface(XTextSection.class, (Object)value);
                    if (xTextSection != null && (xTextSectionPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextSection)) != null) {
                        Boolean visible = (Boolean)xTextSectionPropertySet.getPropertyValue("IsVisible");
                        select = visible;
                    }
                    if (select) {
                        textDocument.setSelection(new XInterfaceObjectSelection((XInterface)cellRange.getXCellRange()));
                    }
                }
            }
        }
        catch (Throwable throwable) {}
    }

    @Override
    public void merge(ITextTableCellRange textTableCellRange) {
        ITextTableCellRangeName cellRangeName = textTableCellRange.getRangeName();
        String startCell = String.valueOf(TextTableCellNameHelper.getColumnCharacter(cellRangeName.getRangeStartColumnIndex())) + (cellRangeName.getRangeStartRowIndex() + 1);
        String endCell = String.valueOf(TextTableCellNameHelper.getColumnCharacter(cellRangeName.getRangeEndColumnIndex())) + (cellRangeName.getRangeEndRowIndex() + 1);
        XTextTableCursor cur = this.xTextTable.createCursorByCellName(startCell);
        cur.gotoCellByName(endCell, true);
        cur.mergeRange();
    }

    @Override
    public void split(ITextTableCellRange textTableCellRange, int cellCount, boolean vertical) {
        ITextTableCellRangeName cellRangeName = textTableCellRange.getRangeName();
        String startCell = String.valueOf(TextTableCellNameHelper.getColumnCharacter(cellRangeName.getRangeStartColumnIndex())) + (cellRangeName.getRangeStartRowIndex() + 1);
        String endCell = String.valueOf(TextTableCellNameHelper.getColumnCharacter(cellRangeName.getRangeEndColumnIndex())) + (cellRangeName.getRangeEndRowIndex() + 1);
        XTextTableCursor cur = this.xTextTable.createCursorByCellName(startCell);
        cur.gotoCellByName(endCell, true);
        cur.splitRange((short)cellCount, vertical);
    }

    private void analyseTableFormulas() {
        this.formulaCells = new ArrayList();
        ITextTableRow[] tableRows = this.getRows();
        int i = 0;
        while (i < tableRows.length) {
            ITextTableRow tableRow = tableRows[i];
            if (tableRow != null) {
                ITextTableCell[] cells = tableRow.getCells();
                int j = 0;
                while (j < cells.length) {
                    IFormula formula;
                    IFormulaService formulaService;
                    ITextTableCell cell = cells[j];
                    if (cell != null && (formulaService = cell.getFormulaService()) != null && (formula = formulaService.getFormula()) != null) {
                        this.formulaCells.add(cell);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

