/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.BookmarkService;
import ag.ion.bion.officelayer.internal.text.Text;
import ag.ion.bion.officelayer.internal.text.TextContentService;
import ag.ion.bion.officelayer.internal.text.TextCursorService;
import ag.ion.bion.officelayer.text.IBookmarkService;
import ag.ion.bion.officelayer.text.IText;
import ag.ion.bion.officelayer.text.ITextContentService;
import ag.ion.bion.officelayer.text.ITextCursorService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextService;
import ag.ion.noa.internal.text.AnnotationService;
import ag.ion.noa.text.IAnnotationService;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;

public class TextService
implements ITextService {
    private ITextDocument textDocument = null;
    private XText xText = null;
    private TextContentService textContentService = null;
    private ITextCursorService cursorService = null;
    private IBookmarkService bookmarkService = null;
    private IAnnotationService annotationService = null;
    private Text text = null;
    private XMultiServiceFactory xMultiServiceFactory = null;

    public TextService(ITextDocument textDocument, XMultiServiceFactory xMultiServiceFactory, XText xText) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("The submitted text document is not valid.");
        }
        if (xText == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org interface is not valid.");
        }
        if (xMultiServiceFactory == null) {
            throw new IllegalArgumentException("Submitted multi service factory is not valid.");
        }
        this.xText = xText;
        this.xMultiServiceFactory = xMultiServiceFactory;
        this.textDocument = textDocument;
    }

    @Override
    public ITextContentService getTextContentService() {
        if (this.textContentService == null) {
            this.textContentService = new TextContentService(this.textDocument, this.xMultiServiceFactory, this.xText);
        }
        return this.textContentService;
    }

    @Override
    public ITextCursorService getCursorService() {
        if (this.cursorService == null) {
            this.cursorService = new TextCursorService(this.textDocument, this.xText);
        }
        return this.cursorService;
    }

    @Override
    public IBookmarkService getBookmarkService() {
        if (this.bookmarkService == null) {
            this.bookmarkService = new BookmarkService(this.textDocument);
        }
        return this.bookmarkService;
    }

    @Override
    public IAnnotationService getAnnotationService() {
        if (this.annotationService == null) {
            this.annotationService = new AnnotationService(this.textDocument);
        }
        return this.annotationService;
    }

    @Override
    public IText getText() {
        if (this.text == null) {
            this.text = new Text(this.textDocument, this.xText);
        }
        return this.text;
    }
}

