/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.TextField;
import ag.ion.bion.officelayer.internal.text.TextFieldMaster;
import ag.ion.bion.officelayer.internal.text.VariableTextFieldMaster;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextField;
import ag.ion.bion.officelayer.text.ITextFieldMaster;
import ag.ion.bion.officelayer.text.ITextFieldService;
import ag.ion.bion.officelayer.text.IVariableTextFieldMaster;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextField;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XRefreshable;
import java.util.ArrayList;
import java.util.Arrays;

public class TextFieldService
implements ITextFieldService {
    private static final ITextFieldMaster[] EMPTY_TEXTFIELD_MASTER_ARRAY = new ITextFieldMaster[0];
    private static final String USER_TEXTFIELD_MASTER_PREFIX = "com.sun.star.text.FieldMaster.User.";
    private static final String VARIABLES_TEXTFIELD_MASTER_PREFIX = "com.sun.star.text.FieldMaster.SetExpression.";
    private ITextDocument textDocument = null;

    public TextFieldService(ITextDocument textDocument) {
        if (textDocument == null) {
            throw new IllegalArgumentException("The submitted text document is not valid.");
        }
        this.textDocument = textDocument;
    }

    @Override
    public ITextFieldMaster getUserTextFieldMaster(String name) throws TextException {
        Any any;
        try {
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.textDocument.getXTextDocument());
            XNameAccess xNameAccess = xTextFieldsSupplier.getTextFieldMasters();
            any = null;
            try {
                any = (Any)xNameAccess.getByName(USER_TEXTFIELD_MASTER_PREFIX + name);
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)any);
        if (xPropertySet != null) {
            return new TextFieldMaster(this.textDocument, xPropertySet);
        }
        return null;
    }

    @Override
    public ITextFieldMaster[] getUserTextFieldMasters(String prefix) throws TextException {
        if (prefix == null) {
            return EMPTY_TEXTFIELD_MASTER_ARRAY;
        }
        try {
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.textDocument.getXTextDocument());
            XNameAccess xNameAccess = xTextFieldsSupplier.getTextFieldMasters();
            String[] names = xNameAccess.getElementNames();
            ArrayList<TextFieldMaster> arrayList = new ArrayList<TextFieldMaster>();
            Any any = null;
            XPropertySet xPropertySet = null;
            int i = 0;
            int n = names.length;
            while (i < n) {
                String fieldName;
                String name = names[i];
                if (name.toLowerCase().startsWith(USER_TEXTFIELD_MASTER_PREFIX.toLowerCase()) && (fieldName = name.substring(USER_TEXTFIELD_MASTER_PREFIX.length())).startsWith(prefix)) {
                    try {
                        any = (Any)xNameAccess.getByName(name);
                        xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)any);
                        if (xPropertySet != null) {
                            arrayList.add(new TextFieldMaster(this.textDocument, xPropertySet));
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                ++i;
            }
            return arrayList.toArray(new ITextFieldMaster[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public ITextFieldMaster[] getUserTextFieldMasters(String prefix, String suffix) throws TextException {
        if (prefix == null) {
            return EMPTY_TEXTFIELD_MASTER_ARRAY;
        }
        try {
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.textDocument.getXTextDocument());
            XNameAccess xNameAccess = xTextFieldsSupplier.getTextFieldMasters();
            String[] names = xNameAccess.getElementNames();
            ArrayList<TextFieldMaster> arrayList = new ArrayList<TextFieldMaster>();
            Any any = null;
            XPropertySet xPropertySet = null;
            int i = 0;
            int n = names.length;
            while (i < n) {
                String fieldName;
                String name = names[i];
                if (name.toLowerCase().startsWith(USER_TEXTFIELD_MASTER_PREFIX.toLowerCase()) && (fieldName = name.substring(USER_TEXTFIELD_MASTER_PREFIX.length())).startsWith(prefix) && fieldName.endsWith(suffix)) {
                    try {
                        any = (Any)xNameAccess.getByName(name);
                        xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)any);
                        if (xPropertySet != null) {
                            arrayList.add(new TextFieldMaster(this.textDocument, xPropertySet));
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                ++i;
            }
            return arrayList.toArray(new ITextFieldMaster[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public ITextField addUserTextField(String name, String content) throws TextException {
        try {
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.textDocument.getXTextDocument());
            Object textField = xMultiServiceFactory.createInstance("com.sun.star.text.TextField.User");
            XDependentTextField xDependentTextField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)textField);
            Object oFieldMaster = xMultiServiceFactory.createInstance("com.sun.star.text.FieldMaster.User");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oFieldMaster);
            xPropertySet.setPropertyValue("Name", (Object)name);
            xPropertySet.setPropertyValue("Content", (Object)content);
            xDependentTextField.attachTextFieldMaster(xPropertySet);
            return new TextField(this.textDocument, xDependentTextField);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public ITextField[] getUserTextFields() throws TextException {
        try {
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.textDocument.getXTextDocument());
            XEnumerationAccess xEnumerationAccess = xTextFieldsSupplier.getTextFields();
            XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
            ArrayList<TextField> arrayList = new ArrayList<TextField>();
            while (xEnumeration.hasMoreElements()) {
                Object object = xEnumeration.nextElement();
                XTextField xTextField = (XTextField)UnoRuntime.queryInterface(XTextField.class, (Object)object);
                arrayList.add(new TextField(this.textDocument, xTextField));
            }
            return arrayList.toArray(new ITextField[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public ITextField[] getPlaceholderFields() throws TextException {
        try {
            PropertyValue[] pfs = this.textDocument.getXTextDocument().getArgs();
            int i = 0;
            while (i < pfs.length) {
                if (pfs[i].Name.endsWith("Hidden") && pfs[i].Value.equals(true)) {
                    XRefreshable refresh = null;
                    refresh = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)this.textDocument.getXTextDocument());
                    refresh.refresh();
                    break;
                }
                ++i;
            }
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.textDocument.getXTextDocument());
            XEnumerationAccess xEnumerationAccess = xTextFieldsSupplier.getTextFields();
            XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
            ArrayList<TextField> arrayList = new ArrayList<TextField>();
            while (xEnumeration.hasMoreElements()) {
                Object object = xEnumeration.nextElement();
                XTextField xTextField = (XTextField)UnoRuntime.queryInterface(XTextField.class, (Object)object);
                XServiceInfo xInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xTextField);
                if (!xInfo.supportsService("com.sun.star.text.TextField.JumpEdit")) continue;
                arrayList.add(new TextField(this.textDocument, xTextField));
            }
            this.textDocument.setModified(false);
            return arrayList.toArray(new ITextField[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public ITextField createPlaceholderTextField(String name, String hint, short placeholderType) throws TextException {
        try {
            if (name == null) {
                throw new TextException("The placeholders name to create can not be null.");
            }
            if (placeholderType < 0 || placeholderType > 4) {
                throw new TextException("The placeholder type must be one of the valid static members of com.sun.star.text.PlaceholderType.");
            }
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.textDocument.getXTextDocument());
            Object textField = xMultiServiceFactory.createInstance("com.sun.star.text.TextField.JumpEdit");
            XTextField xTextField = (XTextField)UnoRuntime.queryInterface(XTextField.class, (Object)textField);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextField);
            xPropertySet.setPropertyValue("PlaceHolder", (Object)name);
            xPropertySet.setPropertyValue("PlaceHolderType", (Object)new Short(placeholderType));
            if (hint != null) {
                xPropertySet.setPropertyValue("Hint", (Object)hint);
            }
            return new TextField(this.textDocument, xTextField);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public IVariableTextFieldMaster getVariableTextFieldMaster(String masterName) throws TextException {
        Any any;
        try {
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.textDocument.getXTextDocument());
            XNameAccess xNameAccess = xTextFieldsSupplier.getTextFieldMasters();
            any = null;
            try {
                String name = masterName;
                if (!name.toLowerCase().startsWith(VARIABLES_TEXTFIELD_MASTER_PREFIX.toLowerCase())) {
                    name = VARIABLES_TEXTFIELD_MASTER_PREFIX + name;
                }
                any = (Any)xNameAccess.getByName(name);
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)any);
        if (xPropertySet != null) {
            return new VariableTextFieldMaster(this.textDocument, xPropertySet);
        }
        return null;
    }

    @Override
    public IVariableTextFieldMaster[] getVariableTextFieldMasters(String prefix) throws TextException {
        try {
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.textDocument.getXTextDocument());
            XNameAccess xNameAccess = xTextFieldsSupplier.getTextFieldMasters();
            String[] names = xNameAccess.getElementNames();
            ArrayList<VariableTextFieldMaster> masters = new ArrayList<VariableTextFieldMaster>();
            int i = 0;
            while (i < names.length) {
                block7: {
                    if (names[i].toLowerCase().startsWith((VARIABLES_TEXTFIELD_MASTER_PREFIX + prefix).toLowerCase())) {
                        Any any = null;
                        try {
                            any = (Any)xNameAccess.getByName(names[i]);
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            break block7;
                        }
                        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)any);
                        if (xPropertySet != null) {
                            masters.add(new VariableTextFieldMaster(this.textDocument, xPropertySet));
                        }
                    }
                }
                ++i;
            }
            return masters.toArray(new IVariableTextFieldMaster[masters.size()]);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public IVariableTextFieldMaster createVariableTextFieldMaster(String name, short variableType) throws TextException {
        try {
            if (name == null) {
                throw new TextException("The variable name to create can not be null.");
            }
            if (variableType < 0 || variableType > 3) {
                throw new TextException("The variable type must be one of the valid static members of com.sun.star.text.SetVariableType.");
            }
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.textDocument.getXTextDocument());
            Object oFieldMaster = xMultiServiceFactory.createInstance("com.sun.star.text.FieldMaster.SetExpression");
            XPropertySet xMasterPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oFieldMaster);
            xMasterPropertySet.setPropertyValue("Name", (Object)name);
            xMasterPropertySet.setPropertyValue("SubType", (Object)new Short(variableType));
            return new VariableTextFieldMaster(this.textDocument, xMasterPropertySet);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public ITextField[] getVariableFields(String prefix) throws TextException {
        try {
            IVariableTextFieldMaster[] masters = this.getVariableTextFieldMasters(prefix);
            ArrayList<ITextField> arrayList = new ArrayList<ITextField>();
            int i = 0;
            while (i < masters.length) {
                ITextField[] variables = masters[i].getVariableTextFields();
                arrayList.addAll(Arrays.asList(variables));
                ++i;
            }
            return arrayList.toArray(new ITextField[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public void refresh() throws TextException {
        try {
            XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.textDocument.getXTextDocument());
            XRefreshable xRefreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xTextFieldsSupplier.getTextFields());
            xRefreshable.refresh();
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }
}

