/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.event.IElementDisposedListener;
import ag.ion.bion.officelayer.internal.event.ElementDisposeListenerWrapper;
import ag.ion.bion.officelayer.internal.text.TextFieldMaster;
import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.text.AbstractTextComponent;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextField;
import ag.ion.bion.officelayer.text.ITextFieldMaster;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.noa.text.TextRangeSelection;
import com.sun.star.lang.XEventListener;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextField;
import com.sun.star.uno.UnoRuntime;

public class TextField
extends AbstractTextComponent
implements ITextField {
    private XDependentTextField xDependentTextField = null;
    private ElementDisposeListenerWrapper wrapper = null;

    public TextField(ITextDocument textDocument, XDependentTextField xDependentTextField) throws IllegalArgumentException {
        super(textDocument);
        if (xDependentTextField == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org interface is not valid.");
        }
        this.xDependentTextField = xDependentTextField;
    }

    public TextField(ITextDocument textDocument, XTextField xTextField) throws IllegalArgumentException {
        super(textDocument);
        this.xDependentTextField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)xTextField);
        if (this.xDependentTextField == null) {
            throw new IllegalArgumentException("The submitted OpenOffice.org XTextField interface is not valid");
        }
    }

    @Override
    public XTextContent getXTextContent() {
        return this.xDependentTextField;
    }

    @Override
    public String getDisplayText() {
        return this.xDependentTextField.getPresentation(false);
    }

    @Override
    public ITextFieldMaster getTextFieldMaster() {
        return new TextFieldMaster(this.textDocument, this.xDependentTextField.getTextFieldMaster());
    }

    @Override
    public ITextRange getTextRange() {
        return new TextRange(this.textDocument, this.xDependentTextField.getAnchor());
    }

    @Override
    public void remove() {
        this.xDependentTextField.dispose();
    }

    @Override
    public void addDisposeListener(IElementDisposedListener listener) {
        this.wrapper = new ElementDisposeListenerWrapper(listener);
        this.addEventListener(this.wrapper);
    }

    @Override
    public void removeDisposeListener(IElementDisposedListener listener) {
        if (this.wrapper != null) {
            this.removeEventListener(this.wrapper);
        }
    }

    private void addEventListener(XEventListener xEventListener) {
        XTextField xTextField = (XTextField)UnoRuntime.queryInterface(XTextField.class, (Object)this.xDependentTextField);
        xTextField.addEventListener((XEventListener)this.wrapper);
    }

    private void removeEventListener(XEventListener xEventListener) {
        XTextField xTextField = (XTextField)UnoRuntime.queryInterface(XTextField.class, (Object)this.xDependentTextField);
        xTextField.removeEventListener((XEventListener)this.wrapper);
    }

    @Override
    public void markTextField() {
        try {
            ITextDocument textDocument = this.getTextDocument();
            textDocument.setSelection(new TextRangeSelection(this.getTextRange()));
        }
        catch (Exception exception) {}
    }
}

