/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.document.AbstractDocument;
import ag.ion.bion.officelayer.document.DocumentException;
import ag.ion.bion.officelayer.internal.text.PageService;
import ag.ion.bion.officelayer.internal.text.TextFieldService;
import ag.ion.bion.officelayer.internal.text.TextService;
import ag.ion.bion.officelayer.internal.text.TextTableService;
import ag.ion.bion.officelayer.internal.text.ViewCursorService;
import ag.ion.bion.officelayer.internal.util.NumberFormatService;
import ag.ion.bion.officelayer.text.IPageService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextFieldService;
import ag.ion.bion.officelayer.text.ITextService;
import ag.ion.bion.officelayer.text.ITextTableService;
import ag.ion.bion.officelayer.text.IViewCursorService;
import ag.ion.bion.officelayer.util.INumberFormatService;
import ag.ion.noa.document.ISearchService;
import ag.ion.noa.internal.document.SearchService;
import ag.ion.noa.internal.text.DocumentIndexService;
import ag.ion.noa.text.IDocumentIndexService;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XRefreshable;
import com.sun.star.util.XSearchable;
import com.sun.star.view.XSelectionSupplier;
import com.sun.star.view.XViewSettingsSupplier;

public class TextDocument
extends AbstractDocument
implements ITextDocument {
    private XTextDocument xTextDocument = null;
    private XMultiServiceFactory xMultiServiceFactory = null;
    private TextFieldService textFieldService = null;
    private TextService textService = null;
    private TextTableService textTableService = null;
    private ViewCursorService viewCursorService = null;
    private PageService pageService = null;
    private NumberFormatService numberFormatService = null;

    public TextDocument(XTextDocument xTextDocument, PropertyValue[] initialProperties) throws IllegalArgumentException {
        super((XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xTextDocument), initialProperties);
        this.xTextDocument = xTextDocument;
        this.xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDocument);
    }

    @Override
    public XTextDocument getXTextDocument() {
        return this.xTextDocument;
    }

    @Override
    public String getDocumentType() {
        return "Text Document";
    }

    public XMultiServiceFactory getMultiServiceFactory() throws Exception {
        XMultiServiceFactory multiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        return multiServiceFactory;
    }

    @Override
    public IPageService getPageService() {
        if (this.pageService == null) {
            this.pageService = new PageService(this);
        }
        return this.pageService;
    }

    @Override
    public ITextFieldService getTextFieldService() {
        if (this.textFieldService == null) {
            this.textFieldService = new TextFieldService(this);
        }
        return this.textFieldService;
    }

    @Override
    public ITextService getTextService() {
        if (this.textService == null) {
            this.textService = new TextService(this, this.xMultiServiceFactory, this.xTextDocument.getText());
        }
        return this.textService;
    }

    @Override
    public IViewCursorService getViewCursorService() {
        if (this.viewCursorService == null) {
            this.viewCursorService = new ViewCursorService(this);
        }
        return this.viewCursorService;
    }

    @Override
    public ITextTableService getTextTableService() {
        if (this.textTableService == null) {
            this.textTableService = new TextTableService(this);
        }
        return this.textTableService;
    }

    @Override
    public INumberFormatService getNumberFormatService() {
        if (this.numberFormatService == null) {
            XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)this.xTextDocument);
            this.numberFormatService = new NumberFormatService(this, xNumberFormatsSupplier);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.numberFormatService;
    }

    @Override
    public void reformat() {
        this.xTextDocument.reformat();
    }

    @Override
    public void update() {
        ((XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)this.xTextDocument)).refresh();
    }

    @Override
    public ISearchService getSearchService() {
        XSearchable searchable = (XSearchable)UnoRuntime.queryInterface(XSearchable.class, (Object)this.xComponent);
        return new SearchService(this, searchable);
    }

    @Override
    public IDocumentIndexService getIndexService() {
        return new DocumentIndexService(this.xTextDocument);
    }

    @Override
    public void zoom(short zoomType, short zoomValue) throws DocumentException {
        try {
            XViewSettingsSupplier viewSettingsSupplier;
            XController xController;
            XSelectionSupplier selectionSupplier;
            if (zoomType != 3 && zoomType != 2 && zoomType != 0 && zoomType != 1 && zoomType != 4) {
                throw new DocumentException("Invalid zoom type.");
            }
            if (zoomType == 3 && (zoomValue < 20 || zoomValue > 600)) {
                throw new DocumentException("Invalid zoom value. Use values between 20 and 600.");
            }
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.getXComponent());
            if (xModel != null && (selectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)(xController = xModel.getCurrentController()))) != null && (viewSettingsSupplier = (XViewSettingsSupplier)UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xController)) != null) {
                XPropertySet propertySet = viewSettingsSupplier.getViewSettings();
                propertySet.setPropertyValue("ZoomType", (Object)new Short(zoomType));
                if (zoomType == 3) {
                    propertySet.setPropertyValue("ZoomValue", (Object)new Short(zoomValue));
                }
            }
        }
        catch (Throwable throwable) {
            throw new DocumentException(throwable);
        }
    }
}

