/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.filter.IFilter;
import ag.ion.bion.officelayer.internal.document.ByteArrayXInputStreamAdapter;
import ag.ion.bion.officelayer.internal.text.CharacterProperties;
import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.text.ICharacterProperties;
import ag.ion.bion.officelayer.text.IPageCursor;
import ag.ion.bion.officelayer.text.ITextCursor;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.IViewCursor;
import ag.ion.noa.NOAException;
import ag.ion.noa.document.URLAdapter;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.style.BreakType;
import com.sun.star.table.XCell;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XSentenceCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XWordCursor;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TextCursor
implements ITextCursor {
    private ITextDocument textDocument = null;
    private XTextCursor xTextCursor = null;
    private XWordCursor xWordCursor = null;
    private XSentenceCursor xSentenceCursor = null;
    private XParagraphCursor xParagraphCursor = null;

    public TextCursor(ITextDocument textDocument, XTextCursor xTextCursor) {
        if (xTextCursor == null) {
            throw new IllegalArgumentException("The submitted OpenOffice.org XTextCursor interface is not valid.");
        }
        this.xTextCursor = xTextCursor;
        if (textDocument == null) {
            throw new IllegalArgumentException("The submitted text document is not valid.");
        }
        this.textDocument = textDocument;
    }

    @Override
    public ICharacterProperties getCharacterProperties() {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xTextCursor);
        return new CharacterProperties(xPropertySet);
    }

    @Override
    public void gotoEnd(boolean mark) {
        this.xTextCursor.gotoEnd(mark);
    }

    @Override
    public void gotoStart(boolean mark) {
        this.xTextCursor.gotoStart(mark);
    }

    @Override
    public void gotoRange(ITextRange range, boolean mark) {
        this.xTextCursor.gotoRange(range.getXTextRange(), mark);
    }

    @Override
    public void setString(String content) {
        if (content != null) {
            this.xTextCursor.setString(content);
        }
    }

    @Override
    public String getString() {
        return this.xTextCursor.getString();
    }

    @Override
    public void goLeft(short stepNumber, boolean mark) {
        this.xTextCursor.goLeft(stepNumber, mark);
    }

    @Override
    public void goRight(short stepNumber, boolean mark) {
        this.xTextCursor.goRight(stepNumber, mark);
    }

    @Override
    public ITextRange getStart() {
        return new TextRange(this.textDocument, this.xTextCursor.getStart());
    }

    @Override
    public ITextRange getEnd() {
        return new TextRange(this.textDocument, this.xTextCursor.getEnd());
    }

    @Override
    public short getStartPageNumber() {
        IViewCursor viewCursor = this.textDocument.getViewCursorService().getViewCursor();
        IPageCursor pageCursor = viewCursor.getPageCursor();
        if (pageCursor != null) {
            viewCursor.goToRange(this.getStart(), false);
            return pageCursor.getPage();
        }
        return -1;
    }

    @Override
    public short getEndPageNumber() {
        IViewCursor viewCursor = this.textDocument.getViewCursorService().getViewCursor();
        IPageCursor pageCursor = viewCursor.getPageCursor();
        if (pageCursor != null) {
            viewCursor.goToRange(this.getEnd(), false);
            return pageCursor.getPage();
        }
        return -1;
    }

    @Override
    public void insertPageBreak() throws NOAException {
        try {
            XCell xCell = (XCell)UnoRuntime.queryInterface(XCell.class, (Object)this.xTextCursor.getText());
            XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xTextCursor);
            propertySet.setPropertyValue("BreakType", (Object)BreakType.PAGE_AFTER);
            if (xCell == null) {
                this.xTextCursor.getText().insertControlCharacter((XTextRange)this.xTextCursor, (short)0, false);
            }
        }
        catch (Throwable throwable) {
            throw new NOAException("Error inserting page break.", throwable);
        }
    }

    @Override
    public void insertDocument(String url) throws NOAException {
        if (url == null) {
            return;
        }
        try {
            XDocumentInsertable xDocumentInsertable = (XDocumentInsertable)UnoRuntime.queryInterface(XDocumentInsertable.class, (Object)this.xTextCursor);
            if (xDocumentInsertable != null) {
                xDocumentInsertable.insertDocumentFromURL(URLAdapter.adaptURL(url), new PropertyValue[0]);
            }
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public void insertDocument(InputStream inputStream, IFilter filter) throws NOAException {
        if (inputStream == null || filter == null) {
            return;
        }
        FileOutputStream outputStream = null;
        File tempFile = null;
        try {
            try {
                XDocumentInsertable xDocumentInsertable = (XDocumentInsertable)UnoRuntime.queryInterface(XDocumentInsertable.class, (Object)this.xTextCursor);
                if (xDocumentInsertable != null) {
                    boolean useOld = true;
                    if (useOld) {
                        byte[] buffer = new byte[65535];
                        int bytes = -1;
                        tempFile = File.createTempFile("noatemp" + System.currentTimeMillis(), "tmp");
                        tempFile.deleteOnExit();
                        outputStream = new FileOutputStream(tempFile);
                        while ((bytes = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytes);
                        }
                        this.insertDocument(tempFile.getAbsolutePath());
                    } else {
                        PropertyValue[] loadProps = new PropertyValue[2];
                        loadProps[0] = new PropertyValue();
                        loadProps[0].Name = "InputStream";
                        loadProps[0].Value = new ByteArrayXInputStreamAdapter(inputStream, null);
                        loadProps[1] = new PropertyValue();
                        loadProps[1].Name = "FilterName";
                        loadProps[1].Value = filter.getFilterDefinition(this.textDocument);
                        xDocumentInsertable.insertDocumentFromURL("private:stream", loadProps);
                    }
                }
            }
            catch (Throwable throwable) {
                throw new NOAException(throwable);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (tempFile != null) {
                tempFile.delete();
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    @Override
    public boolean supportsWordCursor() {
        if (this.xWordCursor != null) {
            return true;
        }
        XWordCursor xWordCursor = (XWordCursor)UnoRuntime.queryInterface(XWordCursor.class, (Object)this.xTextCursor);
        if (xWordCursor != null) {
            this.xWordCursor = xWordCursor;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStartOfWord() throws NOAException {
        if (this.supportsWordCursor()) {
            return this.xWordCursor.isStartOfWord();
        }
        throw new NOAException("Word cursor operations not supported");
    }

    @Override
    public boolean isEndOfWord() throws NOAException {
        if (this.supportsWordCursor()) {
            return this.xWordCursor.isEndOfWord();
        }
        throw new NOAException("Word cursor operations not supported");
    }

    @Override
    public boolean gotoNextWord(boolean mark) throws NOAException {
        if (this.supportsWordCursor()) {
            return this.xWordCursor.gotoNextWord(mark);
        }
        throw new NOAException("Word cursor operations not supported");
    }

    @Override
    public boolean gotoPreviousWord(boolean mark) throws NOAException {
        if (this.supportsWordCursor()) {
            return this.xWordCursor.gotoPreviousWord(mark);
        }
        throw new NOAException("Word cursor operations not supported");
    }

    @Override
    public boolean gotoEndOfWord(boolean mark) throws NOAException {
        if (this.supportsWordCursor()) {
            return this.xWordCursor.gotoEndOfWord(mark);
        }
        throw new NOAException("Word cursor operations not supported");
    }

    @Override
    public boolean gotoStartOfWord(boolean mark) throws NOAException {
        if (this.supportsWordCursor()) {
            return this.xWordCursor.gotoStartOfWord(mark);
        }
        throw new NOAException("Word cursor operations not supported");
    }

    @Override
    public boolean supportsSentenceCursor() {
        if (this.xSentenceCursor != null) {
            return true;
        }
        XSentenceCursor xSentenceCursor = (XSentenceCursor)UnoRuntime.queryInterface(XSentenceCursor.class, (Object)this.xTextCursor);
        if (xSentenceCursor != null) {
            this.xSentenceCursor = xSentenceCursor;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStartOfSentence() throws NOAException {
        if (this.supportsSentenceCursor()) {
            return this.xSentenceCursor.isStartOfSentence();
        }
        throw new NOAException("Sentence cursor operations not supported");
    }

    @Override
    public boolean isEndOfSentence() throws NOAException {
        if (this.supportsSentenceCursor()) {
            return this.xSentenceCursor.isEndOfSentence();
        }
        throw new NOAException("Sentence cursor operations not supported");
    }

    @Override
    public void gotoNextSentence(boolean mark) throws NOAException {
        if (!this.supportsSentenceCursor()) {
            throw new NOAException("Sentence cursor operations not supported");
        }
        this.xSentenceCursor.gotoNextSentence(mark);
    }

    @Override
    public void gotoPreviousSentence(boolean mark) throws NOAException {
        if (!this.supportsSentenceCursor()) {
            throw new NOAException("Sentence cursor operations not supported");
        }
        this.xSentenceCursor.gotoPreviousSentence(mark);
    }

    @Override
    public void gotoEndOfSentence(boolean mark) throws NOAException {
        if (!this.supportsSentenceCursor()) {
            throw new NOAException("Sentence cursor operations not supported");
        }
        this.xSentenceCursor.gotoEndOfSentence(mark);
    }

    @Override
    public void gotoStartOfSentence(boolean mark) throws NOAException {
        if (!this.supportsSentenceCursor()) {
            throw new NOAException("Sentence cursor operations not supported");
        }
        this.xSentenceCursor.gotoStartOfSentence(mark);
    }

    @Override
    public boolean supportsParagraphCursor() {
        if (this.xParagraphCursor != null) {
            return true;
        }
        XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)this.xTextCursor);
        if (xParagraphCursor != null) {
            this.xParagraphCursor = xParagraphCursor;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStartOfParagraph() throws NOAException {
        if (this.supportsParagraphCursor()) {
            return this.xParagraphCursor.isStartOfParagraph();
        }
        throw new NOAException("Paragraph cursor operations not supported");
    }

    @Override
    public boolean isEndOfParagraph() throws NOAException {
        if (this.supportsParagraphCursor()) {
            return this.xParagraphCursor.isEndOfParagraph();
        }
        throw new NOAException("Paragraph cursor operations not supported");
    }

    @Override
    public void gotoNextParagraph(boolean mark) throws NOAException {
        if (!this.supportsParagraphCursor()) {
            throw new NOAException("Paragraph cursor operations not supported");
        }
        this.xParagraphCursor.gotoNextParagraph(mark);
    }

    @Override
    public void gotoPreviousParagraph(boolean mark) throws NOAException {
        if (!this.supportsParagraphCursor()) {
            throw new NOAException("Paragraph cursor operations not supported");
        }
        this.xParagraphCursor.gotoPreviousParagraph(mark);
    }

    @Override
    public void gotoEndOfParagraph(boolean mark) throws NOAException {
        if (!this.supportsParagraphCursor()) {
            throw new NOAException("Paragraph cursor operations not supported");
        }
        this.xParagraphCursor.gotoEndOfParagraph(mark);
    }

    @Override
    public void gotoStartOfParagraph(boolean mark) throws NOAException {
        if (!this.supportsParagraphCursor()) {
            throw new NOAException("Paragraph cursor operations not supported");
        }
        this.xParagraphCursor.gotoStartOfParagraph(mark);
    }
}

