/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.beans.IPropertyStore;
import ag.ion.bion.officelayer.beans.PropertyKeysContainer;
import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ClonedObject;
import ag.ion.bion.officelayer.clone.IClonedObject;
import ag.ion.bion.officelayer.clone.IDestinationPosition;
import ag.ion.bion.officelayer.internal.clone.AbstractCloneService;
import ag.ion.bion.officelayer.internal.text.ParagraphProperties;
import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.IParagraphProperties;
import ag.ion.bion.officelayer.text.IParagraphPropertyStore;
import ag.ion.bion.officelayer.text.ITextContentService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextService;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;

public class ParagraphCloneService
extends AbstractCloneService {
    private IParagraph paragraph = null;
    private ITextDocument document = null;
    private XMultiServiceFactory serviceFactory = null;
    private IParagraphPropertyStore paragraphPropertyStore = null;
    private String paragraphText = null;

    public ParagraphCloneService(IParagraph paragraph, ITextDocument document) throws CloneException {
        this.paragraph = paragraph;
        this.document = document;
        this.serviceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)document.getXTextDocument());
        try {
            this.analyseParagraph(paragraph);
        }
        catch (TextException excep) {
            CloneException cloneException = new CloneException(excep.getMessage());
            cloneException.initCause(excep);
            throw cloneException;
        }
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition range, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(range, true, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, true, false, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition range, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(range, adoptContent, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, adoptContent, false, propertyKeysContainer);
    }

    private IClonedObject clonePreprocessor(IDestinationPosition position, boolean adoptContent, boolean generateReturnValue, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        block9: {
            try {
                ITextService service = this.document.getTextService();
                ITextContentService contentService = service.getTextContentService();
                if (contentService == null) break block9;
                IParagraph newParagraph = contentService.constructNewParagraph();
                ITextRange range = null;
                if (ITextRange.class.isAssignableFrom(position.getType())) {
                    range = (ITextRange)position.getDestinationObject();
                }
                if (range != null) {
                    contentService.insertTextContent(range, newParagraph);
                } else {
                    contentService.insertTextContentAfter(this.paragraph, newParagraph);
                }
                if (adoptContent) {
                    newParagraph.setParagraphText(this.paragraphText);
                }
                String[] propertyKeysToCopy = null;
                propertyKeysToCopy = propertyKeysContainer != null ? propertyKeysContainer.getPropertyKeys("ag.ion.bion.officelayer.text.ParagraphProperties") : ParagraphProperties.getDefaultPropertyKeys();
                if (propertyKeysToCopy != null) {
                    IParagraphProperties paragraphProperties = newParagraph.getParagraphProperties();
                    ((IPropertyStore)((Object)this.paragraphPropertyStore)).getProperties().copyTo(propertyKeysToCopy, paragraphProperties);
                }
                if (generateReturnValue) {
                    return new ClonedObject(newParagraph, newParagraph.getClass());
                }
                return null;
            }
            catch (Exception excep) {
                CloneException cloneException = new CloneException(excep.getMessage());
                cloneException.initCause(excep);
                throw cloneException;
            }
        }
        throw new CloneException("Error constructing TextContentService to clone paragraph");
    }

    private void analyseParagraph(IParagraph paragraph) throws TextException {
        this.paragraphPropertyStore = paragraph.getParagraphPropertyStore();
        this.paragraphText = paragraph.getParagraphText();
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, true, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, true, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, adoptContent, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, adoptContent, propertyKeysContainer);
    }
}

