/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.internal.text.CharacterProperties;
import ag.ion.bion.officelayer.internal.text.CharacterPropertyStore;
import ag.ion.bion.officelayer.internal.text.ParagraphCloneService;
import ag.ion.bion.officelayer.internal.text.ParagraphProperties;
import ag.ion.bion.officelayer.internal.text.ParagraphPropertyStore;
import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.text.AbstractTextComponent;
import ag.ion.bion.officelayer.text.ICharacterProperties;
import ag.ion.bion.officelayer.text.ICharacterPropertyStore;
import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.IParagraphProperties;
import ag.ion.bion.officelayer.text.IParagraphPropertyStore;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;

public class Paragraph
extends AbstractTextComponent
implements IParagraph {
    private XTextContent xTextContentOrig = null;
    private XTextContent xTextContentAfterInsert = null;

    public Paragraph(ITextDocument textDocument, XTextContent xTextContent) throws IllegalArgumentException {
        super(textDocument);
        if (xTextContent == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XTextContent interface is not valid.");
        }
        this.xTextContentOrig = xTextContent;
    }

    @Override
    public XTextContent getXTextContent() {
        return this.xTextContentAfterInsert == null ? this.xTextContentOrig : this.xTextContentAfterInsert;
    }

    @Override
    public void setXTextContent(XTextContent xTextContent) {
        this.xTextContentAfterInsert = xTextContent;
    }

    @Override
    public ITextRange getTextRange() {
        return new TextRange(this.textDocument, this.getXTextContent().getAnchor());
    }

    @Override
    public IParagraphProperties getParagraphProperties() {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.getXTextContent());
        return new ParagraphProperties(xPropertySet);
    }

    @Override
    public ICharacterProperties getCharacterProperties() {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.getXTextContent());
        return new CharacterProperties(xPropertySet);
    }

    @Override
    public IParagraphPropertyStore getParagraphPropertyStore() throws TextException {
        return new ParagraphPropertyStore(this);
    }

    @Override
    public ICharacterPropertyStore getCharacterPropertyStore() throws TextException {
        return new CharacterPropertyStore(this);
    }

    @Override
    public ICloneService getCloneService() throws CloneException {
        return new ParagraphCloneService(this, this.textDocument);
    }

    @Override
    public String getParagraphText() throws TextException {
        StringBuffer buffer = new StringBuffer();
        XEnumerationAccess contentEnumerationAccess = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)this.getXTextContent());
        XEnumeration enumeration = contentEnumerationAccess.createEnumeration();
        while (enumeration.hasMoreElements()) {
            try {
                Any any = (Any)enumeration.nextElement();
                XTextRange content = (XTextRange)any.getObject();
                buffer.append(content.getString());
            }
            catch (Exception exception) {
                System.out.println("Error getting elements from enumeration while search paragraph text.");
            }
        }
        return buffer.toString();
    }

    @Override
    public void setParagraphText(String text) {
        if (text != null) {
            XTextRange anchor = this.getXTextContent().getAnchor();
            XText xText = anchor.getText();
            xText.insertString(anchor, text, false);
        }
    }
}

