/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.Page;
import ag.ion.bion.officelayer.internal.text.PagePosition;
import ag.ion.bion.officelayer.text.IPage;
import ag.ion.bion.officelayer.text.IPageCursor;
import ag.ion.bion.officelayer.text.IPageService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.frame.XController;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;

public class PageService
implements IPageService {
    private ITextDocument textDocument = null;

    public PageService(ITextDocument textDocument) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        this.textDocument = textDocument;
    }

    @Override
    public int getPageCount() {
        IPageCursor pageCursor = this.textDocument.getViewCursorService().getViewCursor().getPageCursor();
        short currentPage = pageCursor.getPage();
        pageCursor.jumpToLastPage();
        short lastPage = pageCursor.getPage();
        pageCursor.jumpToPage(currentPage);
        return lastPage;
    }

    @Override
    public IPage getPage(int index) throws TextException {
        try {
            XController xController = this.textDocument.getXTextDocument().getCurrentController();
            XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
            XTextViewCursor textViewCursor = xTextViewCursorSupplier.getViewCursor();
            XPageCursor pageCursor = (XPageCursor)UnoRuntime.queryInterface(XPageCursor.class, (Object)textViewCursor);
            pageCursor.jumpToPage((short)index);
            pageCursor.jumpToStartOfPage();
            XTextRange pageStart = textViewCursor.getStart();
            PagePosition startPagePosition = new PagePosition(this.textDocument, pageStart);
            pageCursor.jumpToEndOfPage();
            XTextRange pageEnd = textViewCursor.getStart();
            PagePosition endPagePosition = new PagePosition(this.textDocument, pageEnd);
            return new Page(this.textDocument, startPagePosition, endPagePosition);
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }
}

