/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.internal.text.TextTableCell;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextTableCell;
import com.sun.star.table.XCell;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.UnoRuntime;

public class PagePosition {
    public static final short PLAIN_TEXT = 99;
    public static final short TEXT_TABLE_CELL = 100;
    private ITextDocument textDocument = null;
    private XTextRange xTextRange = null;

    public PagePosition(ITextDocument textDocument, XTextRange xTextRange) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        this.textDocument = textDocument;
        if (xTextRange == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XTextRange interface is not valid.");
        }
        this.xTextRange = xTextRange;
    }

    public short getContentType() {
        XCell xCell = (XCell)UnoRuntime.queryInterface(XCell.class, (Object)this.xTextRange.getText());
        if (xCell == null) {
            return 99;
        }
        return 100;
    }

    public ITextTableCell getTextTableCell() {
        if (this.getContentType() == 100) {
            TextTableCell textTableCell = new TextTableCell(this.textDocument, (XCell)UnoRuntime.queryInterface(XCell.class, (Object)this.xTextRange.getText()));
            return textTableCell;
        }
        return null;
    }

    public ITextRange getTextRange() {
        if (this.getContentType() == 99) {
            TextRange textRange = new TextRange(this.textDocument, this.xTextRange);
            return textRange;
        }
        return null;
    }
}

