/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.beans.IPropertyKey;
import ag.ion.bion.officelayer.internal.beans.AbstractProperties;
import ag.ion.bion.officelayer.internal.beans.PropertyKey;
import ag.ion.bion.officelayer.text.ICharacterProperties;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.awt.FontSlant;
import com.sun.star.beans.XPropertySet;

public class CharacterProperties
extends AbstractProperties
implements ICharacterProperties {
    private static String[] DEFAULT_PROPERTY_KEYS = null;
    private static IPropertyKey[] PROPERTY_KEYS = null;

    public CharacterProperties(XPropertySet xPropertySet) throws IllegalArgumentException {
        super(xPropertySet);
    }

    public static IPropertyKey[] getPossiblyPropertyKeys() {
        if (PROPERTY_KEYS == null) {
            PROPERTY_KEYS = new PropertyKey[]{new PropertyKey("CharHeight", null, null), new PropertyKey("CharWeight", null, null), new PropertyKey("CharPosture", null, null), new PropertyKey("CharUnderline", null, null), new PropertyKey("CharColor", null, null), new PropertyKey("CharUnderlineColor", null, null), new PropertyKey("CharFontName", null, null), new PropertyKey("CharFontStyleName", null, null), new PropertyKey("CharFontFamily", null, null), new PropertyKey("CharFontCharSet", null, null), new PropertyKey("CharFontPitch", null, null)};
        }
        return PROPERTY_KEYS;
    }

    public static String[] getDefaultPropertyKeys() {
        if (DEFAULT_PROPERTY_KEYS == null) {
            DEFAULT_PROPERTY_KEYS = new String[]{"CharColor", "CharHeight", "CharWeight", "CharUnderline", "CharPosture", "CharUnderlineColor", "CharFontName", "CharFontStyleName", "CharFontFamily", "CharFontCharSet", "CharFontPitch"};
        }
        return DEFAULT_PROPERTY_KEYS;
    }

    @Override
    public String getTypeID() {
        return "ag.ion.bion.officelayer.text.CharacterProperties";
    }

    @Override
    public float getFontSize() throws TextException {
        try {
            return ((Float)this.getXPropertySet().getPropertyValue("CharHeight")).floatValue();
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void setFontSize(float fontSize) throws TextException {
        try {
            this.getXPropertySet().setPropertyValue("CharHeight", (Object)new Float(fontSize));
        }
        catch (Exception excep) {
            TextException textException = new TextException(excep.getMessage());
            textException.initCause(excep);
            throw textException;
        }
    }

    @Override
    public boolean isFontBold() throws TextException {
        try {
            float help = ((Float)this.getXPropertySet().getPropertyValue("CharWeight")).floatValue();
            return help == 150.0f;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void setFontBold(boolean param) throws TextException {
        try {
            float weight = param ? 150.0f : 100.0f;
            this.getXPropertySet().setPropertyValue("CharWeight", (Object)new Float(weight));
        }
        catch (Exception excep) {
            TextException textException = new TextException(excep.getMessage());
            textException.initCause(excep);
            throw textException;
        }
    }

    @Override
    public boolean isFontItalic() throws TextException {
        try {
            FontSlant help = (FontSlant)this.getXPropertySet().getPropertyValue("CharPosture");
            return help == FontSlant.ITALIC;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void setFontItalic(boolean param) throws TextException {
        try {
            if (param) {
                this.getXPropertySet().setPropertyValue("CharPosture", (Object)FontSlant.ITALIC);
            } else {
                this.getXPropertySet().setPropertyValue("CharPosture", (Object)FontSlant.NONE);
            }
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public boolean isFontUnderlined() throws TextException {
        try {
            short help = (Short)this.getXPropertySet().getPropertyValue("CharUnderline");
            return help != 0;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void setFontUnderline(boolean param) throws TextException {
        short help = (short)(param ? 1 : 0);
        try {
            this.getXPropertySet().setPropertyValue("CharUnderline", (Object)new Short(help));
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public int getFontColor() throws TextException {
        try {
            return (Integer)this.getXPropertySet().getPropertyValue("CharColor");
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void setFontColor(int color) throws TextException {
        try {
            this.getXPropertySet().setPropertyValue("CharColor", (Object)new Integer(color));
        }
        catch (Exception excep) {
            TextException textException = new TextException(excep.getMessage());
            textException.initCause(excep);
            throw textException;
        }
    }

    @Override
    public String getFontName() throws TextException {
        try {
            return this.getXPropertySet().getPropertyValue("CharFontName").toString();
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void setFontName(String font) throws TextException {
        try {
            this.getXPropertySet().setPropertyValue("CharFontName", (Object)font);
        }
        catch (Exception excep) {
            TextException textException = new TextException(excep.getMessage());
            textException.initCause(excep);
            throw textException;
        }
    }
}

