/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.text.AbstractTextComponent;
import ag.ion.bion.officelayer.text.IAnnotation;
import ag.ion.bion.officelayer.text.ITextComponent;
import ag.ion.bion.officelayer.text.ITextContent;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextField;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.IViewCursor;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextContent;
import com.sun.star.uno.UnoRuntime;

public class Annotation
extends AbstractTextComponent
implements IAnnotation,
ITextContent,
ITextComponent {
    private XDependentTextField xDependentTextField = null;

    public Annotation(ITextDocument textDocument, ITextField textField) throws IllegalArgumentException {
        super(textDocument);
        if (textField == null || !(textField.getXTextContent() instanceof XDependentTextField)) {
            throw new IllegalArgumentException("Submitted OpenOffice.org interface is not valid.");
        }
        this.xDependentTextField = (XDependentTextField)textField.getXTextContent();
    }

    public Annotation(ITextDocument textDocument, XDependentTextField xDependentTextField) throws IllegalArgumentException {
        super(textDocument);
        if (xDependentTextField == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org interface is not valid.");
        }
        this.xDependentTextField = xDependentTextField;
    }

    @Override
    public String getText() {
        XServiceInfo info = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.getXTextContent());
        if (info.supportsService("com.sun.star.text.TextField.Annotation")) {
            XPropertySet properties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.getXTextContent());
            try {
                return (String)properties.getPropertyValue("Content");
            }
            catch (UnknownPropertyException unknownPropertyException) {
            }
            catch (WrappedTargetException wrappedTargetException) {}
        }
        return null;
    }

    @Override
    public ITextRange getTextRange() {
        return new TextRange(this.textDocument, this.xDependentTextField.getAnchor());
    }

    @Override
    public void jumpTo() {
        IViewCursor viewCursor = this.getTextDocument().getViewCursorService().getViewCursor();
        viewCursor.goToRange(this.getTextRange(), false);
    }

    @Override
    public XTextContent getXTextContent() {
        return this.xDependentTextField;
    }
}

