/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.presentation;

import ag.ion.bion.officelayer.presentation.IPageService;
import ag.ion.bion.officelayer.presentation.IPresentationDocument;
import ag.ion.bion.officelayer.presentation.PresentationException;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XDrawView;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.presentation.XPresentationPage;
import com.sun.star.uno.UnoRuntime;

public class PageService
implements IPageService {
    private IPresentationDocument presentationDocument = null;

    public PageService(IPresentationDocument presentationDocument) throws IllegalArgumentException {
        if (presentationDocument == null) {
            throw new IllegalArgumentException("Submitted presentation document is not valid.");
        }
        this.presentationDocument = presentationDocument;
    }

    @Override
    public int getPageCount() {
        try {
            XDrawPagesSupplier dSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.presentationDocument.getXComponent());
            XDrawPages pages = dSupplier.getDrawPages();
            return pages.getCount();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void goToPage(int index) throws PresentationException {
        try {
            XDrawPagesSupplier dSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.presentationDocument.getXComponent());
            XDrawPages pages = dSupplier.getDrawPages();
            UnoRuntime.queryInterface(XDrawPage.class, (Object)pages.getByIndex(index));
            XPresentationPage page = (XPresentationPage)UnoRuntime.queryInterface(XPresentationPage.class, (Object)pages.getByIndex(index));
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.presentationDocument.getPresentationSupplier());
            XController xController = xModel.getCurrentController();
            XDrawView drawView = (XDrawView)UnoRuntime.queryInterface(XDrawView.class, (Object)xController);
            drawView.setCurrentPage((XDrawPage)page);
        }
        catch (Throwable throwable) {
            PresentationException textException = new PresentationException(throwable.getMessage());
            textException.initCause(throwable);
            throw textException;
        }
    }
}

