/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.document;

import ag.ion.bion.officelayer.internal.document.Messages;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XSeekable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lib.uno.helper.ComponentBase;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayXInputStreamAdapter
extends ComponentBase
implements XInputStream,
XSeekable {
    private IOfficeProgressMonitor officeProgressMonitor = null;
    private byte[] bytes = null;
    private int length = -1;
    private int pos = -1;
    private int counter = 0;
    private int buildCounter = 0;
    private boolean showBuildInformation = false;

    public ByteArrayXInputStreamAdapter(InputStream inputStream, IOfficeProgressMonitor officeProgressMonitor) throws IOException {
        this(officeProgressMonitor, ByteArrayXInputStreamAdapter.toByteArray(inputStream));
    }

    public ByteArrayXInputStreamAdapter(byte[] bytes) throws java.lang.IllegalArgumentException {
        this(null, bytes);
    }

    public ByteArrayXInputStreamAdapter(IOfficeProgressMonitor officeProgressMonitor, byte[] bytes) throws java.lang.IllegalArgumentException {
        if (bytes == null) {
            throw new java.lang.IllegalArgumentException("The submitted bytes are not valid.");
        }
        this.bytes = bytes;
        this.length = bytes.length;
        this.pos = 0;
        this.officeProgressMonitor = officeProgressMonitor;
        if (officeProgressMonitor != null) {
            officeProgressMonitor.beginTask(Messages.getString("ByteArrayXInputStreamAdapter_monitor_task_name"), this.length);
        }
    }

    public int available() throws com.sun.star.io.IOException {
        long available = this.length - this.pos;
        if (available != (long)((int)available)) {
            throw new com.sun.star.io.IOException("Integer overflow.");
        }
        return (int)available;
    }

    public void closeInput() throws com.sun.star.io.IOException {
        this.bytes = null;
    }

    public int readBytes(byte[][] buffer, int size) throws BufferSizeExceededException, com.sun.star.io.IOException {
        try {
            int remain = this.length - this.pos;
            if (size > remain) {
                size = remain;
            }
            if (buffer[0] == null) {
                buffer[0] = new byte[size];
            }
            System.arraycopy(this.bytes, this.pos, buffer[0], 0, size);
            if (this.pos >= this.counter) {
                this.counter += size;
            } else {
                int difference = this.counter - this.pos;
                this.counter += size - difference;
            }
            this.pos += size;
            if (this.officeProgressMonitor != null) {
                if (!this.showBuildInformation) {
                    this.officeProgressMonitor.worked(size);
                    this.officeProgressMonitor.beginSubTask(Messages.getString("ByteArrayXInputStreamAdapter_monitor_sub_task", new Object[]{new Integer(this.counter), new Integer(this.length)}));
                } else {
                    this.officeProgressMonitor.beginSubTask(Messages.getString("ByteArrayXInputStreamAdapter__monitor_integrating", new Integer(this.buildCounter++)));
                }
                if (this.counter >= this.length) {
                    this.showBuildInformation = true;
                }
            }
            return size;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BufferSizeExceededException("Buffer overflow.");
        }
        catch (Exception exception) {
            throw new com.sun.star.io.IOException("Error accessing byte array.");
        }
    }

    public int readSomeBytes(byte[][] buffer, int size) throws BufferSizeExceededException, com.sun.star.io.IOException {
        return this.readBytes(buffer, size);
    }

    public void skipBytes(int size) throws BufferSizeExceededException, com.sun.star.io.IOException {
        if (size > this.length - this.pos) {
            throw new BufferSizeExceededException("Buffer overflow.");
        }
        this.pos += size;
    }

    public long getLength() throws com.sun.star.io.IOException {
        if (this.bytes != null) {
            return this.length;
        }
        throw new com.sun.star.io.IOException("No bytes available.");
    }

    public long getPosition() throws com.sun.star.io.IOException {
        if (this.bytes != null) {
            return this.pos;
        }
        throw new com.sun.star.io.IOException("No bytes available.");
    }

    public void seek(long position) throws IllegalArgumentException, com.sun.star.io.IOException {
        if (this.bytes != null) {
            if (position < 0L || position > (long)this.length) {
                throw new IllegalArgumentException("Invalid seek position.");
            }
        } else {
            throw new com.sun.star.io.IOException("No bytes available.");
        }
        this.pos = (int)position;
    }

    private static final byte[] toByteArray(InputStream inputStream) throws IOException {
        int size = 4096;
        int read = 0;
        int counter = 0;
        byte[] buffer = new byte[size];
        byte[] newBuffer = null;
        while ((read = inputStream.read(buffer, counter, buffer.length - counter)) > 0) {
            if (inputStream.available() <= buffer.length - (counter += read)) continue;
            newBuffer = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, newBuffer, 0, counter);
            buffer = newBuffer;
        }
        if (buffer.length != counter) {
            newBuffer = new byte[counter];
            System.arraycopy(buffer, 0, newBuffer, 0, counter);
            buffer = newBuffer;
        }
        return buffer;
    }
}

