/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.desktop;

import ag.ion.bion.officelayer.NativeView;
import ag.ion.bion.officelayer.application.connection.IOfficeConnection;
import ag.ion.bion.officelayer.desktop.DesktopException;
import ag.ion.bion.officelayer.desktop.IDesktopService;
import ag.ion.bion.officelayer.desktop.IFrame;
import ag.ion.bion.officelayer.event.IDocumentListener;
import ag.ion.bion.officelayer.event.ITerminateListener;
import ag.ion.bion.officelayer.event.VetoTerminateListener;
import ag.ion.bion.officelayer.internal.application.connection.LocalOfficeConnection;
import ag.ion.bion.officelayer.internal.desktop.Frame;
import ag.ion.bion.officelayer.internal.event.DocumentListenerWrapper;
import ag.ion.bion.officelayer.internal.event.TerminateListenerWrapper;
import ag.ion.noa.NOAException;
import ag.ion.noa.internal.service.ServiceProvider;
import ag.ion.noa.service.IServiceProvider;
import com.sun.star.document.XEventBroadcaster;
import com.sun.star.document.XEventListener;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrames;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.uno.UnoRuntime;
import java.awt.Container;
import java.util.Hashtable;

public class DesktopService
implements IDesktopService {
    private XDesktop xDesktop = null;
    private IOfficeConnection officeConnection = null;
    private XEventBroadcaster eventBroadcaster = null;
    private Hashtable terminateListeners = null;
    private Hashtable documentListeners = null;
    private VetoTerminateListener vetoTerminateListener = null;
    private boolean preventTermination = false;

    public DesktopService(XDesktop xDesktop, IOfficeConnection officeConnection) throws IllegalArgumentException {
        this(xDesktop, officeConnection, false);
    }

    public DesktopService(XDesktop xDesktop, IOfficeConnection officeConnection, boolean preventTermination) throws IllegalArgumentException {
        if (xDesktop == null) {
            throw new IllegalArgumentException("The submitted OpenOffice.org XDesktop interface is not valid.");
        }
        this.xDesktop = xDesktop;
        if (officeConnection == null) {
            throw new IllegalArgumentException("The submitted connection to OpenOffice.org is not valid.");
        }
        this.officeConnection = officeConnection;
        if (preventTermination) {
            this.activateTerminationPrevention();
        }
    }

    @Override
    public void terminate() throws NOAException {
        try {
            this.xDesktop.terminate();
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public void activateTerminationPrevention() {
        if (!this.preventTermination) {
            if (this.vetoTerminateListener == null) {
                this.vetoTerminateListener = new VetoTerminateListener();
            }
            this.addTerminateListener(this.vetoTerminateListener);
            this.preventTermination = true;
        }
    }

    @Override
    public void deactivateTerminationPrevention() {
        if (this.preventTermination) {
            if (this.vetoTerminateListener != null) {
                this.removeTerminateListener(this.vetoTerminateListener);
            }
            this.preventTermination = false;
        }
    }

    @Override
    public void addTerminateListener(ITerminateListener terminateListener) {
        if (this.terminateListeners == null) {
            this.terminateListeners = new Hashtable();
        }
        TerminateListenerWrapper terminateListenerWrapper = new TerminateListenerWrapper(terminateListener, (IServiceProvider)new ServiceProvider(this.officeConnection));
        this.xDesktop.addTerminateListener((XTerminateListener)terminateListenerWrapper);
        this.terminateListeners.put(terminateListener, terminateListenerWrapper);
    }

    @Override
    public void removeTerminateListener(ITerminateListener terminateListener) {
        if (this.terminateListeners == null) {
            return;
        }
        TerminateListenerWrapper terminateListenerWrapper = (TerminateListenerWrapper)this.terminateListeners.get(terminateListener);
        if (terminateListenerWrapper != null) {
            this.xDesktop.removeTerminateListener((XTerminateListener)terminateListenerWrapper);
        }
    }

    @Override
    public void addDocumentListener(IDocumentListener documentListener) throws DesktopException {
        try {
            if (this.documentListeners == null) {
                this.documentListeners = new Hashtable();
            }
            if (this.eventBroadcaster == null) {
                Object globalEventBroadcaster = this.officeConnection.getXMultiServiceFactory().createInstance("com.sun.star.frame.GlobalEventBroadcaster");
                this.eventBroadcaster = (XEventBroadcaster)UnoRuntime.queryInterface(XEventBroadcaster.class, (Object)globalEventBroadcaster);
            }
            DocumentListenerWrapper documentListenerWrapper = new DocumentListenerWrapper(documentListener, (IServiceProvider)new ServiceProvider(this.officeConnection));
            this.eventBroadcaster.addEventListener((XEventListener)documentListenerWrapper);
            this.documentListeners.put(documentListener, documentListenerWrapper);
        }
        catch (Exception exception) {
            throw new DesktopException(exception);
        }
    }

    @Override
    public void removeDocumentListener(IDocumentListener documentListener) {
        if (documentListener == null) {
            return;
        }
        DocumentListenerWrapper documentListenerWrapper = (DocumentListenerWrapper)this.documentListeners.get(documentListener);
        if (documentListenerWrapper != null) {
            this.eventBroadcaster.removeEventListener((XEventListener)documentListenerWrapper);
        }
    }

    @Override
    public IFrame constructNewOfficeFrame(Container container) throws DesktopException {
        if (this.officeConnection instanceof LocalOfficeConnection) {
            XFrame xFrame = ((LocalOfficeConnection)this.officeConnection).getOfficeFrame(container);
            Frame frame = new Frame(xFrame, this.officeConnection);
            return frame;
        }
        throw new DesktopException("New frames can only constructed for local OpenOffice.org applications.");
    }

    @Override
    public IFrame constructNewOfficeFrame(NativeView nativeView) throws DesktopException {
        if (this.officeConnection instanceof LocalOfficeConnection) {
            XFrame xFrame = ((LocalOfficeConnection)this.officeConnection).getOfficeFrame(nativeView);
            Frame frame = new Frame(xFrame, this.officeConnection);
            return frame;
        }
        throw new DesktopException("New frames can only constructed for local OpenOffice.org applications.");
    }

    @Override
    public void dispose() {
        this.terminateListeners = null;
        this.documentListeners = null;
        this.deactivateTerminationPrevention();
    }

    @Override
    public int getFramesCount() {
        if (this.xDesktop == null) {
            return -1;
        }
        XFrames xFrames = ((XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)this.xDesktop)).getFrames();
        if (xFrames == null) {
            return -1;
        }
        return xFrames.getCount();
    }
}

