/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application;

import ag.ion.bion.officelayer.application.IApplicationProperties;
import ag.ion.bion.officelayer.application.ILazyApplicationInfo;

public class LazyApplicationInfo
implements ILazyApplicationInfo {
    private static final String PRODUCT_NAME = "OpenOffice.org";
    private IApplicationProperties applicationProperties = null;
    private String home = null;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int updateVersion = -1;

    public LazyApplicationInfo(String home, IApplicationProperties applicationProperties) throws IllegalArgumentException {
        if (home == null) {
            throw new IllegalArgumentException("The submitted home path is not valid.");
        }
        this.home = home;
        this.applicationProperties = applicationProperties;
        if (applicationProperties != null) {
            this.intitVersion(applicationProperties);
        }
    }

    public void setVersion(int major, int minor, int update) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.updateVersion = update;
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public IApplicationProperties getProperties() {
        return this.applicationProperties;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getUpdateVersion() {
        return this.updateVersion;
    }

    private void intitVersion(IApplicationProperties applicationProperties) {
        String productKey = applicationProperties.getPropertyValue("ProductKey");
        if (productKey != null) {
            String version = productKey.substring(PRODUCT_NAME.length()).trim();
            String[] versionParts = version.split("\\.");
            int majorVersion = 0;
            int minorVersion = 0;
            int updateVersion = 0;
            int i = 0;
            int n = versionParts.length;
            while (i < n) {
                int number = -1;
                try {
                    number = Integer.parseInt(versionParts[i]);
                }
                catch (Throwable throwable) {}
                if (i == 0) {
                    majorVersion = number;
                } else if (i == 1) {
                    minorVersion = number;
                } else if (i == 2) {
                    updateVersion = number;
                }
                ++i;
            }
            this.setVersion(majorVersion, minorVersion, updateVersion);
        }
    }
}

