/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application;

import ag.ion.bion.officelayer.application.IApplicationInfo;
import ag.ion.noa.service.IServiceProvider;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class ApplicationInfo
implements IApplicationInfo {
    private IServiceProvider serviceProvider = null;

    public ApplicationInfo(IServiceProvider serviceProvider) throws Exception {
        if (serviceProvider == null) {
            throw new Exception("A service provider is needed for the ApplicationInfo. This should not happen.");
        }
        this.serviceProvider = serviceProvider;
    }

    @Override
    public String getName() throws Exception {
        String sInfo;
        Object info = this.getInfo("/org.openoffice.Setup/Product", "ooName");
        if (info != null && info instanceof String && (sInfo = (String)info).length() > 0) {
            return sInfo;
        }
        return null;
    }

    @Override
    public String getVersion() throws Exception {
        String sInfo;
        Object info = this.getInfo("/org.openoffice.Setup/Product", "ooSetupVersionAboutBox");
        if (info != null && info instanceof String && (sInfo = (String)info).length() > 0) {
            return sInfo;
        }
        return null;
    }

    @Override
    public int getMajorVersion() throws Exception {
        String sInfo;
        Object info = this.getInfo("/org.openoffice.Setup/Product", "ooSetupVersionAboutBox");
        if (info != null && info instanceof String && (sInfo = (String)info).length() > 0) {
            return Integer.valueOf(sInfo.split("\\.")[0]);
        }
        return -1;
    }

    @Override
    public int getMinorVersion() throws Exception {
        String sInfo;
        Object info = this.getInfo("/org.openoffice.Setup/Product", "ooSetupVersionAboutBox");
        if (info != null && info instanceof String && (sInfo = (String)info).length() > 0) {
            return Integer.valueOf(sInfo.split("\\.")[1]);
        }
        return -1;
    }

    @Override
    public int getUpdateVersion() throws Exception {
        String sInfo;
        Object info = this.getInfo("/org.openoffice.Setup/Product", "ooSetupVersionAboutBox");
        if (info != null && info instanceof String && (sInfo = (String)info).length() > 0) {
            return Integer.valueOf(sInfo.split("\\.")[2]);
        }
        return -1;
    }

    @Override
    public String getLocale() throws Exception {
        String sInfo;
        Object info = this.getInfo("/org.openoffice.Setup/L10N", "ooLocale");
        if (info != null && info instanceof String && (sInfo = (String)info).length() > 0) {
            return sInfo;
        }
        return null;
    }

    @Override
    public Date getLicenseAcceptDate() throws Exception {
        String sInfo;
        Object info = this.getInfo("/org.openoffice.Setup/Office", "LicenseAcceptDate");
        if (info != null && info instanceof String && (sInfo = (String)info).length() > 0) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(sInfo);
        }
        return null;
    }

    @Override
    public Boolean getFirstStartWizardCompleted() throws Exception {
        Object info = this.getInfo("/org.openoffice.Setup/Office", "FirstStartWizardCompleted");
        if (info != null && info instanceof Boolean) {
            return (Boolean)info;
        }
        return null;
    }

    @Override
    public Object getInfo(String path, String key) throws Exception {
        Object configProviderObject = this.serviceProvider.createService("com.sun.star.comp.configuration.ConfigurationProvider");
        XMultiServiceFactory xConfigServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)configProviderObject);
        String readConfAccess = "com.sun.star.configuration.ConfigurationAccess";
        Object[] properties = new PropertyValue[]{new PropertyValue()};
        properties[0].Name = "nodepath";
        properties[0].Value = path;
        Object configReadAccessObject = xConfigServiceFactory.createInstanceWithArguments(readConfAccess, properties);
        XNameAccess xConfigNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)configReadAccessObject);
        return xConfigNameAccess.getByName(key);
    }

    @Override
    public void dumpInfo() throws Exception {
        this.dumpInfo(null);
    }

    @Override
    public void dumpInfo(String path) throws Exception {
        if (path == null || path.length() == 0) {
            path = "/org.openoffice.Setup";
        }
        Object configProviderObject = this.serviceProvider.createService("com.sun.star.comp.configuration.ConfigurationProvider");
        XMultiServiceFactory xConfigServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)configProviderObject);
        String readConfAccess = "com.sun.star.configuration.ConfigurationAccess";
        Object[] properties = new PropertyValue[]{new PropertyValue()};
        properties[0].Name = "nodepath";
        properties[0].Value = path;
        Object configReadAccessObject = xConfigServiceFactory.createInstanceWithArguments(readConfAccess, properties);
        XNameAccess xConfigNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)configReadAccessObject);
        String[] names = xConfigNameAccess.getElementNames();
        System.out.println(path);
        System.out.println("=======================================");
        int i = 0;
        while (i < names.length) {
            Object element = xConfigNameAccess.getByName(names[i]);
            if (element instanceof String || element instanceof Boolean || element instanceof Number || element instanceof Character || element instanceof CharSequence) {
                System.out.println(String.valueOf(names[i]) + ": " + element);
            } else if (element instanceof String[]) {
                System.out.println(String.valueOf(names[i]) + ": " + Arrays.asList((String[])element).toString());
            } else if (!(element instanceof Any)) {
                this.dumpInfo(String.valueOf(path) + "/" + names[i]);
            }
            ++i;
        }
    }
}

