/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer;

import ag.ion.bion.officelayer.OSHelper;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;

public class NativeView
extends Canvas {
    static final long serialVersionUID = 744155902373436284L;
    public Integer maHandle;
    public int maSystem;
    private Dimension preferredSize = new Dimension(500, 300);
    private Dimension minSize = new Dimension(100, 100);
    private Dimension maxSize = new Dimension(1024, 768);
    private String libPath = null;

    public native int getNativeWindowSystemType();

    private native long getNativeWindow();

    public NativeView() {
        this.maHandle = null;
        this.maSystem = 0;
        this.setBackground(Color.white);
        this.loadLibrary();
    }

    public NativeView(String nativeLibPath) {
        this.libPath = nativeLibPath;
        this.maHandle = null;
        this.maSystem = 0;
        this.setBackground(Color.white);
        this.loadLibrary();
    }

    @Override
    public void setVisible(boolean bState) {
        this.getHWND();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.preferredSize = preferredSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.maxSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minSize;
    }

    @Override
    public void paint(Graphics aGraphic) {
        if (this.maHandle == null) {
            Dimension aSize = this.getSize();
            aGraphic.clearRect(0, 0, aSize.width, aSize.height);
        }
    }

    public Integer getHWND() {
        if (this.maHandle == null) {
            this.maHandle = new Integer((int)this.getNativeWindow());
            this.maSystem = this.getNativeWindowSystemType();
        }
        return this.maHandle;
    }

    private void loadLibrary() {
        String libPathFromProps = System.getProperty("noa.native.lib.path");
        if (libPathFromProps != null) {
            this.libPath = libPathFromProps;
        }
        if (this.libPath != null) {
            boolean is64Bit;
            String libName = "libnativeview.so";
            String folder64bit = "64bit";
            if (OSHelper.IS_WINDOWS) {
                libName = "nativeview.dll";
            }
            boolean bl = is64Bit = Integer.valueOf(System.getProperties().getProperty("sun.arch.data.model")) == 64;
            if (is64Bit && new File(String.valueOf(this.libPath) + File.separator + folder64bit + File.separator + libName).exists()) {
                this.libPath = String.valueOf(this.libPath) + File.separator + folder64bit;
            }
            System.load(String.valueOf(this.libPath) + File.separator + libName);
        } else if (OSHelper.IS_LINUX || OSHelper.IS_MAC) {
            String libName = "libnativeview.so";
            boolean is64Bit = Integer.valueOf(System.getProperties().getProperty("sun.arch.data.model")) == 64;
            this.libPath = "/usr/lib" + (is64Bit ? "64" : "");
            System.load(String.valueOf(this.libPath) + File.separator + libName);
        } else {
            System.loadLibrary("nativeview");
        }
    }
}

