/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.helper;

import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.IParagraphProperties;
import ag.ion.bion.officelayer.text.ITextCursor;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextFieldService;
import ag.ion.bion.officelayer.text.ITextService;
import ag.ion.bion.officelayer.text.TextException;
import java.awt.Font;

public class TextHandler {
    private final ITextDocument doc;
    private final ITextService textservice;
    private final ITextFieldService textfieldservice;

    public TextHandler(ITextDocument doc) {
        this.doc = doc;
        this.textservice = doc.getTextService();
        this.textfieldservice = doc.getTextFieldService();
    }

    public void append(String text) throws TextException {
        ITextCursor textCursor = this.getTextservice().getText().getTextCursorService().getTextCursor();
        textCursor.getEnd().setText(text);
    }

    public void appendBefore(String text) throws TextException {
        ITextCursor textCursor = this.getTextservice().getText().getTextCursorService().getTextCursor();
        textCursor.getStart().setText(text);
    }

    public void setAlign(int paragraph, short align) throws TextException {
        IParagraph[] paragraphs = this.getDoc().getTextService().getText().getTextContentEnumeration().getParagraphs();
        IParagraphProperties paragraphPropoerties = paragraphs[paragraph].getParagraphProperties();
        paragraphPropoerties.setParaAdjust(align);
    }

    public void setTextFormat(int paragraph, Font font, int color) throws TextException {
        IParagraph[] paragraphs = this.getTextservice().getText().getTextContentEnumeration().getParagraphs();
        IParagraphProperties paragraphPropoerties = paragraphs[paragraph].getParagraphProperties();
        paragraphPropoerties.getCharacterProperties().setFontBold(font.isBold());
        paragraphPropoerties.getCharacterProperties().setFontSize(font.getSize());
        paragraphPropoerties.getCharacterProperties().setFontItalic(font.isItalic());
        paragraphPropoerties.getCharacterProperties().setFontColor(color);
    }

    public void addParagraphs(String[] text) throws TextException {
        int i = 0;
        while (i < text.length) {
            ITextCursor textCursor = this.getTextservice().getText().getTextCursorService().getTextCursor();
            textCursor.gotoEnd(false);
            IParagraph paragraph = this.getTextservice().getTextContentService().constructNewParagraph();
            textCursor.gotoEnd(false);
            this.getTextservice().getTextContentService().insertTextContent(textCursor.getEnd(), paragraph);
            paragraph.setParagraphText(text[i]);
            ++i;
        }
    }

    public String getParagraph(int paragraph) throws TextException {
        return this.getTextservice().getText().getTextContentEnumeration().getParagraphs()[paragraph].getParagraphText();
    }

    public ITextDocument getDoc() {
        return this.doc;
    }

    public ITextService getTextservice() {
        return this.textservice;
    }

    public ITextFieldService getTextfieldservice() {
        return this.textfieldservice;
    }
}

