/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.text.templator.model;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.text.GenericDocument;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.rgw.io.FileTool;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageController
extends Job
implements Heartbeat.HeartListener {
    private static final Logger log = LoggerFactory.getLogger(StorageController.class);
    private IDocumentManager dm;
    private List<Metafile> metafiles = new ArrayList<Metafile>();
    private static StorageController theInstance;
    private String category = null;

    private static StorageController getInstance() {
        if (theInstance == null) {
            theInstance = new StorageController();
        }
        return theInstance;
    }

    private StorageController() {
        super("Ungrad-Text-Templator");
        this.dm = (IDocumentManager)Extensions.findBestService((String)"DocumentManagement");
        this.category = CoreHub.localCfg.get("briefe/ungrad-templator/category", "-");
        this.setPriority(50);
        this.setSystem(true);
        this.setUser(false);
        CoreHub.heart.addListener((Heartbeat.HeartListener)this);
    }

    public File createFile(Patient pat, String name) throws IOException {
        String ext = "templator." + FileTool.getExtension((String)name);
        File dest = File.createTempFile("elexis", ext);
        dest.deleteOnExit();
        if (CoreHub.localCfg.get("briefe/ungrad-templator/save", true) && this.dm != null && pat != null) {
            Metafile mf = new Metafile(pat, name, this.category, System.currentTimeMillis(), dest);
            this.metafiles.add(mf);
        } else {
            log.debug("DocumentManager null [" + (this.dm == null) + "], Patient null ([" + (pat == null) + "])");
        }
        return dest;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Iterator<Metafile> it = this.metafiles.iterator();
        while (it.hasNext()) {
            try {
                Metafile mf = it.next();
                if (mf.guid == null) {
                    this.addDocument(mf);
                    continue;
                }
                File exists = mf.fileOnDisk;
                if (exists.lastModified() <= mf.timestamp) continue;
                this.dm.removeDocument(mf.guid);
                this.addDocument(mf);
            }
            catch (Exception ex) {
                SWTHelper.showError((String)"Templator", (String)"Fehler bei der Verarbeitung:", (String)ex.getMessage());
            }
        }
        return Status.OK_STATUS;
    }

    private void addDocument(Metafile mf) throws Exception {
        if (mf.category == null) {
            mf.category = "-";
        } else if (StringTool.getIndex((String[])this.dm.getCategories(), (String)mf.category) == -1) {
            this.dm.addCategorie(mf.category);
        }
        GenericDocument gd = new GenericDocument(mf.pat, mf.name, mf.category, mf.fileOnDisk, new TimeTool().toString(4), "", null);
        this.dm.addDocument((IOpaqueDocument)gd);
        mf.guid = gd.getGUID();
        mf.timestamp = mf.fileOnDisk.lastModified();
    }

    public void heartbeat() {
        this.schedule();
    }

    private class Metafile {
        String name;
        long timestamp;
        String category;
        String guid = null;
        Patient pat;
        File fileOnDisk;

        Metafile(Patient p, String n, String c, long t, File f) {
            this.name = n;
            this.category = c;
            this.timestamp = t;
            this.pat = p;
            this.fileOnDisk = f;
        }
    }
}

