/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.text.templator.model;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.ungrad.StorageController;
import ch.elexis.ungrad.text.templator.model.OdfTemplateFilterStream;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ODFDoc {
    private Map<String, String> fields = new HashMap<String, String>();
    private byte[] template;
    private String title;
    private boolean bExternal = false;

    public void clear() {
        this.fields.clear();
    }

    public Map<String, String> parseTemplate(Brief brief) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(brief.loadBinary());
        this.parseTemplate(bais);
        String nt = brief.getBetreff();
        this.title = StringTool.isNothing((Object)nt) ? "Brief" : nt;
        Kontakt k = brief.getAdressat();
        if (k != null) {
            String n2;
            String n1 = k.get("Bezeichnung1");
            if (n1 != null) {
                this.title = String.valueOf(this.title) + "_" + n1;
            }
            if ((n2 = k.get("Bezeichnung2")) != null) {
                this.title = String.valueOf(this.title) + "_" + n2;
            }
        }
        this.bExternal = false;
        return this.fields;
    }

    public Map<String, String> parseTemplate(InputStream tmpl) throws Exception {
        ZipEntry ze;
        ZipInputStream zis = new ZipInputStream(tmpl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        while ((ze = zis.getNextEntry()) != null) {
            zos.putNextEntry(ze);
            if (ze.getName().equals("content.xml") || ze.getName().equals("styles.xml")) {
                byte[] cnt = this.readStream(zis);
                Pattern pFields = Pattern.compile("\\[[\\s\\w\\.:\\/0-9]+\\]");
                new String(cnt, "utf-8");
                Matcher matcher = pFields.matcher(new String(cnt, "utf-8"));
                while (matcher.find()) {
                    String found = matcher.group();
                    this.fields.put(found, found);
                }
                zos.write(cnt);
                continue;
            }
            if (ze.getName().equals("meta.xml")) {
                byte[] meta = this.readStream(zis);
                String s = new String(meta);
                Pattern pTitle = Pattern.compile("<dc:title>(.+)</dc:title>");
                Matcher m = pTitle.matcher(s);
                if (m.find()) {
                    this.title = m.group(1);
                } else {
                    pTitle = Pattern.compile("<meta:template.+?xlink:title=\"(.+?)\"");
                    m = pTitle.matcher(s);
                    if (m.find()) {
                        this.title = m.group(1);
                    }
                }
                zos.write(meta);
                continue;
            }
            FileTool.copyStreams((InputStream)zis, (OutputStream)zos);
        }
        zos.flush();
        zos.close();
        this.template = baos.toByteArray();
        this.bExternal = false;
        return this.fields;
    }

    public void setTemplate(byte[] template, String title) {
        this.template = template;
        this.fields.clear();
        this.title = title;
        this.bExternal = true;
    }

    public Set<Map.Entry<String, String>> getFields() {
        return this.fields.entrySet();
    }

    public String getField(String name) {
        String ret = this.fields.get(name);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public void setField(String name, String value) {
        if (!value.startsWith("??")) {
            this.fields.put(name, value);
        }
    }

    public byte[] asByteArray() throws Exception {
        ZipEntry ze;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(this.template));
        ZipOutputStream zos = new ZipOutputStream(baos);
        while ((ze = zis.getNextEntry()) != null) {
            zos.putNextEntry(ze);
            if (ze.getName().equals("content.xml") || ze.getName().equals("styles.xml")) {
                OdfTemplateFilterStream otf = new OdfTemplateFilterStream(this, zos);
                FileTool.copyStreams((InputStream)zis, (OutputStream)otf);
                continue;
            }
            FileTool.copyStreams((InputStream)zis, (OutputStream)zos);
        }
        zos.close();
        zis.close();
        return baos.toByteArray();
    }

    public boolean doOutput() {
        try {
            StorageController sc = new StorageController();
            File output = sc.createFile(ElexisEventDispatcher.getSelectedPatient(), String.valueOf(this.title) + ".odt");
            if (!this.bExternal || !output.exists()) {
                byte[] contents = this.asByteArray();
                FileTool.writeFile((File)output, (byte[])contents);
            }
            String cmd = CoreHub.localCfg.get("briefe/ungrad-templator/oooprocessor/cmd", "soffice");
            String param = CoreHub.localCfg.get("briefe/ungrad-templator/oooprocessor/param", "%");
            int i = param.indexOf(37);
            if (i != -1) {
                param = String.valueOf(param.substring(0, i)) + output.getAbsolutePath() + param.substring(i + 1);
            }
            Runtime.getRuntime().exec(new String[]{cmd, param});
            return true;
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
            SWTHelper.alert((String)"OpenOffice Processor", (String)("Problem mit dem Erstellen des Dokuments " + e.getMessage()));
            return false;
        }
    }

    private byte[] readStream(InputStream is) throws Exception {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }
}

