/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.pdf;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.ungrad.pdf.Manager;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Medform {
    String form;
    Manager mgr = new Manager();
    Map<String, String> mapping = Stream.of({"patAddress", "topmostSubform[0].page1[0].patientS1Address[0].blockAddress[0]"}, {"patNameLine", "topmostSubform[0].page1[0].patientS1Address[0].condensedName[0]"}, {"patFirstname", "topmostSubform[0].page1[0].patientS1Address[0].firstName[0]"}, {"patLastname", "topmostSubform[0].page1[0].patientS1Address[0].lastName[0]"}, {"patBirthdate", "topmostSubform[0].page1[0].patientS1Address[0].birthDate[0]"}, {"patSex", "topmostSubform[0].page1[0].patientS1Address[0].sex[0]"}, {"patStreet", "topmostSubform[0].page1[0].patientS1Address[0].street[0]"}, {"patZip", "topmostSubform[0].page1[0].patientS1Address[0].zip[0]"}, {"patCity", "topmostSubform[0].page1[0].patientS1Address[0].city[0]"}, {"patPhone1", "topmostSubform[0].page1[0].patientS1Address[0].phone[0]"}, {"patPhone2", "topmostSubform[0].page1[0].patientS1Address[0].phone[1]"}, {"patMail", "topmostSubform[0].page1[0].patientS1Address[0].email[0]"}, {"docDate", "topmostSubform[0].page1[0].formS1Struct[0].modificationDate[0]"}, {"mandatorPhone1", "topmostSubform[0].page1[0].providerS1Address[0].phone[0]"}, {"mandatorMail", "topmostSubform[0].page1[0].providerS1Address[0].email[0]"}, {"mandatorFax", "topmostSubform[0].page1[0].providerS1Address[0].fax[0]"}, {"mandatorEAN", "topmostSubform[0].page1[0].providerS1Address[0].ean[0]"}, {"mandatorZSR", "topmostSubform[0].page1[0].providerS1Address[0].zsr[0]"}, {"mandatorNameLine", "topmostSubform[0].page2[0].providerS1Address[0].condensedName[0]"}, {"mandatorStreet", "topmostSubform[0].page2[0].providerS1Address[0].street[0]"}, {"mandatorZip", "topmostSubform[0].page2[0].providerS1Address[0].zip[0]"}, {"mandatorCity", "topmostSubform[0].page2[0].providerS1Address[0].city[0]"}, {"mandatorAddress", "topmostSubform[0].page1[0].providerS1Address[0].blockAddress[0]"}, {"insuranceName", "topmostSubform[0].page1[0].insuranceS1Address[0].companyName[0]"}, {"insuranceStreet", "topmostSubform[0].page1[0].insuranceS1Address[0].street[0]"}, {"insuranceZip", "topmostSubform[0].page1[0].insuranceS1Address[0].zip[0]"}, {"insuranceCity", "topmostSubform[0].page1[0].insuranceS1Address[0].city[0]"}, {"insuranceMail", "topmostSubform[0].page1[0].insuranceS1Address[0].email[0]"}, {"insuranceCaseNr", "topmostSubform[0].page1[0].lawS1Struct[0].insuredID[0]"}, {"insuranceLaw", "topmostSubform[0].page1[0].lawS1Struct[0].type[0]"}, {"receiverMail", "topmostSubform[0].page1[0].consumerS1Address[0].email[0]"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));

    public Medform(String formpath) {
        this.form = formpath;
    }

    public boolean isMedform() {
        try {
            String oid = this.mgr.getFieldContents(this.form, "topmostSubform[0].page1[0].formS1Struct[0].oid[0]");
            return oid != null && oid.startsWith("medforms");
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
    }

    public String create(String outPath, Patient pat) throws Exception {
        Fall fall;
        Konsultation kons;
        Mandant mand;
        HashMap<String, String> m = new HashMap<String, String>();
        if (pat != null) {
            String[] phones = this.getPhones((Kontakt)pat);
            m.put(this.get("patAddress"), pat.getPostAnschrift(true));
            m.put(this.get("patFirstname"), pat.getVorname());
            m.put(this.get("patLastname"), pat.getName());
            m.put(this.get("patBirthdate"), pat.getGeburtsdatum());
            m.put(this.get("patSex"), pat.getGeschlecht());
            m.put(this.get("patStreet"), pat.get("Strasse"));
            m.put(this.get("patZip"), pat.get("Plz"));
            m.put(this.get("patCity"), pat.get("Ort"));
            m.put(this.get("patPhone1"), phones[0]);
            m.put(this.get("patPhone2"), phones[1]);
            m.put(this.get("patMail"), pat.get("E-Mail"));
            m.put(this.get("docDate"), new TimeTool().toString(4));
        }
        if ((mand = ElexisEventDispatcher.getSelectedMandator()) != null) {
            m.put(this.get("mandatorAddress"), mand.getPostAnschrift(true));
            m.put(this.get("mandatorNameLine"), String.valueOf(mand.get("Bezeichnung1")) + " " + mand.get("Bezeichnung2"));
            m.put(this.get("mandatorEAN"), mand.get("EAN"));
            String ksk = mand.get("KSK");
            if (ksk.startsWith("*") && (ksk = mand.get("ZSR")).startsWith("*")) {
                ksk = "";
            }
            m.put(this.get("mandatorZSR"), ksk);
            m.put(this.get("mandatorStreet"), mand.get("Strasse"));
            m.put(this.get("mandatorZip"), mand.get("Plz"));
            m.put(this.get("mandatorCity"), mand.get("Ort"));
            m.put(this.get("mandatorPhone1"), mand.get("Telefon1"));
            m.put(this.get("mandatorMail"), mand.get("E-Mail"));
        }
        if ((kons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class)) != null && (fall = kons.getFall()) != null) {
            Kontakt cb = fall.getCostBearer();
            if (cb != null) {
                m.put(this.get("insuranceName"), String.valueOf(cb.get("Bezeichnung1")) + " " + cb.get("Bezeichnung2"));
                m.put(this.get("insuranceStreet"), StringTool.unNull((String)cb.get("Strasse")));
                m.put(this.get("insuranceZip"), StringTool.unNull((String)cb.get("Plz")));
                m.put(this.get("insuranceCity"), StringTool.unNull((String)cb.get("Ort")));
                m.put(this.get("insuranceMail"), StringTool.unNull((String)cb.get("E-Mail")));
            }
            BillingLaw bl = fall.getConfiguredBillingSystemLaw();
            String nr = fall.get("VersNummer");
            if (StringTool.isNothing((Object)nr)) {
                nr = fall.get("FallNummer");
            }
            if (StringTool.isNothing((Object)nr)) {
                nr = fall.getInfoString("Versicherungsnummer");
            }
            m.put(this.get("insuranceCaseNr"), StringTool.unNull((String)nr));
            m.put(this.get("insuranceLaw"), bl.toString());
        }
        return this.mgr.fillForm(this.form, outPath, m);
    }

    private String[] getPhones(Kontakt k) {
        String p1 = k.get("Telefon1");
        String p2 = k.get("Telefon2");
        String p3 = k.get("NatelNr");
        String[] ret = new String[2];
        if (!StringTool.isNothing((Object)p3)) {
            ret[0] = p3;
            ret[1] = !StringTool.isNothing((Object)p1) && !p1.equals(p3) ? p1 : (!StringTool.isNothing((Object)p2) && !p2.equals(p3) ? p2 : "");
        } else if (!StringTool.isNothing((Object)p1)) {
            ret[0] = p1;
            ret[1] = !StringTool.isNothing((Object)p2) && !p1.equals(p2) ? p2 : "";
        } else {
            ret[1] = "";
            ret[0] = !StringTool.isNothing((Object)p3) ? p3 : "";
        }
        return ret;
    }

    public String get(String field) {
        String ret = this.mapping.get(field);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public String getFieldValue(String name) {
        String medformsField = this.get(name);
        if (medformsField != null) {
            try {
                return this.mgr.getFieldContents(this.form, medformsField);
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
            }
        }
        return "";
    }
}

