/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.pdf;

import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.printing.PDFPrintable;

public class Manager {
    private PDDocument pdfDoc;

    public String fillForm(String formpath, String outputPath, Map<String, String> fields) throws Exception {
        try {
            if (this.pdfDoc == null) {
                FileInputStream resource = new FileInputStream(formpath);
                this.pdfDoc = PDDocument.load((InputStream)resource);
            }
            PDDocumentCatalog docCatalog = this.pdfDoc.getDocumentCatalog();
            this.pdfDoc.getDocumentInformation().setCreator("Elexis Ungrad");
            this.pdfDoc.getDocumentInformation().setCustomMetadataValue("concern", "Forms");
            PDAcroForm acroForm = docCatalog.getAcroForm();
            for (Map.Entry<String, String> e : fields.entrySet()) {
                PDField pdField = acroForm.getField(e.getKey());
                if (pdField == null) continue;
                try {
                    String val = e.getValue();
                    pdField.setValue(val);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.pdfDoc.save(outputPath);
            this.pdfDoc.close();
            this.pdfDoc = null;
            return outputPath;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return "";
        }
    }

    public String getFieldContents(String formPath, String fieldName) throws Exception {
        PDDocumentCatalog docCatalog;
        PDAcroForm acroForm;
        PDField pdField;
        if (this.pdfDoc == null) {
            this.pdfDoc = PDDocument.load((File)new File(formPath));
        }
        if ((pdField = (acroForm = (docCatalog = this.pdfDoc.getDocumentCatalog()).getAcroForm()).getField(fieldName)) != null) {
            try {
                String val = pdField.getValueAsString();
                return val;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    public void createPDF(File inputHtml, File outputFile) throws FileNotFoundException, IOException, PrinterException {
        FileOutputStream fout = new FileOutputStream(outputFile);
        PdfRendererBuilder builder = ((PdfRendererBuilder)((PdfRendererBuilder)new PdfRendererBuilder().useFastMode()).withFile(inputHtml)).withProducer("Elexis Ungrad");
        builder.toStream((OutputStream)fout);
        builder.run();
    }

    public boolean printFromPDF(File pdfFile, String printer) throws IOException, PrinterException {
        PDDocument pdoc = PDDocument.load((File)pdfFile);
        PDFPrintable printable = new PDFPrintable(pdoc);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable((Printable)printable);
        boolean printed = false;
        if (!StringTool.isNothing((Object)printer)) {
            PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
            int selectedService = 0;
            int i = 0;
            while (i < services.length) {
                if (services[i].getName().toLowerCase().contains(printer.toLowerCase())) {
                    selectedService = i;
                    services[i].getAttributes();
                    break;
                }
                ++i;
            }
            job.setPrintService(services[selectedService]);
            HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
            attrs.add(MediaSizeName.ISO_A4);
            job.print(attrs);
            printed = true;
        } else if (job.printDialog()) {
            job.print();
            printed = true;
        }
        pdoc.close();
        return printed;
    }

    public boolean printFromHTML(File htmlFle, String printer, boolean bKeepHtml, boolean bKeepPdf) {
        return false;
    }
}

