/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.Importer;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.ungrad.labview.controller.Controller;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class LaborView
extends ViewPart
implements IActivationListener {
    Controller controller = new Controller(this);
    Log log = Log.get((String)"LaborView");
    private Action exportHtmlAction;
    private Action viewInBrowserAction;
    private Action importAction;
    private Action removeEmptyItemsAction;
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 16){

        public void runInUi(ElexisEvent ev) {
            try {
                LaborView.this.controller.setPatient((Patient)ev.getObject());
            }
            catch (ElexisException e) {
                LaborView.this.log.log((Throwable)e, "error loading patient data", 2);
            }
        }
    };

    public void createPartControl(Composite parent) {
        CTabFolder cTabFolder = new CTabFolder(parent, 1024);
        cTabFolder.setLayoutData((Object)SWTHelper.getFillGridData());
        CTabItem ctSmart = new CTabItem(cTabFolder, 0);
        ctSmart.setText("Kompakt");
        ctSmart.setControl(this.controller.createSmartControl(cTabFolder));
        CTabItem ctSummary = new CTabItem(cTabFolder, 0);
        ctSummary.setText("Synopsis");
        CTabItem ctFull = new CTabItem(cTabFolder, 0);
        ctFull.setText("Voll");
        Control ctlSummary = this.controller.createSummaryControl(cTabFolder);
        ctSummary.setControl(ctlSummary);
        Control ctlFull = this.controller.createFullControl(cTabFolder);
        ctFull.setControl(ctlFull);
        cTabFolder.setSelection(ctSmart);
        this.makeActions();
        this.contributeToActionBars();
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.controller.loadState();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.exportHtmlAction);
        manager.add((IAction)this.viewInBrowserAction);
        manager.add((IAction)this.importAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.exportHtmlAction);
        manager.add((IAction)this.removeEmptyItemsAction);
    }

    public void setFocus() {
    }

    public void visible(boolean mode) {
        try {
            this.controller.setPatient(ElexisEventDispatcher.getSelectedPatient());
        }
        catch (ElexisException e) {
            this.log.log((Throwable)e, "error loading patient data", 2);
        }
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat});
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat});
            this.controller.saveState();
        }
    }

    public void activation(boolean mode) {
    }

    public void dispose() {
        this.controller.dispose();
    }

    private void makeActions() {
        this.exportHtmlAction = new Action(){
            {
                this.setImageDescriptor(Images.IMG_WEB.getImageDescriptor());
                this.setToolTipText("Laborblatt exportieren");
            }

            public void run() {
                LaborView.this.controller.getExporter().createHTML((Composite)LaborView.this.getSite().getShell());
            }
        };
        this.viewInBrowserAction = new Action(){
            {
                this.setImageDescriptor(Images.IMG_EYE_WO_SHADOW.getImageDescriptor());
                this.setToolTipText("In Browser ansehen");
            }

            public void run() {
                LaborView.this.controller.getExporter().runInBrowser();
            }
        };
        this.importAction = new Action("Labordaten import"){
            {
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
                this.setToolTipText("Resultate importieren");
            }

            public void run() {
                Importer imp = new Importer(LaborView.this.getViewSite().getShell(), "ch.elexis.core.ui.LaborDatenImport");
                imp.create();
                imp.setMessage("Bitte Datenquelle ausw\u00e4hlen");
                imp.getShell().setText("Labordaten import");
                imp.setTitle("Labor Auswahl");
                imp.open();
            }
        };
        this.removeEmptyItemsAction = new RestrictedAction(AccessControlDefaults.DELETE_LABITEMS, "Aufr\u00e4umen"){
            {
                this.setToolTipText("Ungebrauchte Items und Gruppen l\u00f6schen");
                Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/edit-clear24.png"), null);
                this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
            }

            public void doRun() {
                if (SWTHelper.askYesNo((String)"Laboritems aufr\u00e4umen", (String)"Alle Laboritems entfernen, f\u00fcr die keine Resultate existieren. (Das kann sehr lange dauern)")) {
                    LaborView.this.controller.purgeLabItems();
                }
            }
        };
    }
}

