/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.model;

import ch.elexis.ungrad.Util;
import ch.elexis.ungrad.labview.model.Item;
import ch.elexis.ungrad.labview.model.Result;
import java.util.ArrayList;
import java.util.List;

public class Bucket {
    Item item;
    List<Result> results = new ArrayList<Result>();

    Bucket(Item item) {
        Util.require((item != null ? 1 : 0) != 0, (String)"Bucket: item must not be null");
        this.item = item;
    }

    void addResult(Result result) {
        this.results.add(result);
    }

    public int getResultCount() {
        return this.results.size();
    }

    public String getMinResult() {
        float cmp = Float.MAX_VALUE;
        for (Result result : this.results) {
            float val = Item.makeFloat((String)result.get("resultat"));
            if (!(val < cmp)) continue;
            cmp = val;
        }
        return cmp == Float.MAX_VALUE ? "" : Float.toString(cmp);
    }

    public String getMaxResult() {
        float cmp = 0.0f;
        for (Result result : this.results) {
            float val = Item.makeFloat((String)result.get("resultat"));
            if (!(val > cmp)) continue;
            cmp = val;
        }
        return cmp == 0.0f ? "" : Float.toString(cmp);
    }

    public String getAverageResult() {
        int num = 0;
        float sum = 0.0f;
        for (Result result : this.results) {
            sum += Item.makeFloat((String)result.get("resultat"));
            ++num;
        }
        float avg = 100.0f * sum / (float)num;
        float ret = (float)Math.round(avg) / 100.0f;
        return num == 0 ? "" : Float.toString(ret);
    }
}

