/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller.smart;

import ch.elexis.ungrad.labview.controller.Controller;
import ch.elexis.ungrad.labview.controller.DateResultLabelProvider;
import ch.elexis.ungrad.labview.controller.ItemRangeLabelProvider;
import ch.elexis.ungrad.labview.controller.ItemTextLabelProvider;
import ch.elexis.ungrad.labview.controller.smart.SmartSummaryLabelProvider;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.TreeColumn;

public class SmartTreeColumns {
    static final int DEFAULT_WIDTH = 100;
    static final int MAX_WIDTH = 300;
    int numColumns = 7;
    TreeViewer tv;
    TreeViewerColumn[] cols;
    String[] headings = new String[]{"Parameter", "Referenz"};
    int[] widths = new int[]{150, 120};
    int colWidth;

    public SmartTreeColumns(TreeViewer tv) {
        this.tv = tv;
        this.colWidth = 100;
    }

    public void saveColLayout() {
        if (this.cols == null) {
            if (this.widths == null) {
                this.widths = new int[]{150, 120};
            }
        } else {
            if (this.cols.length > this.widths.length) {
                this.widths = new int[this.cols.length];
            }
            int i = 0;
            while (i < this.cols.length - 1) {
                TreeColumn tc;
                int n = this.widths[i] = this.widths[i] == 0 ? this.colWidth : this.widths[i];
                if (this.cols[i] != null && (tc = this.cols[i].getColumn()) != null) {
                    this.widths[i] = this.cols[i].getColumn().getWidth();
                }
                ++i;
            }
        }
    }

    public void setColWidths(int[] widths) {
        this.widths = widths != null && widths.length > 1 ? widths : new int[]{150, 120};
    }

    public void reload(Controller svc) {
        TreeColumn[] treeColumnArray = this.tv.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn tc = treeColumnArray[n2];
            tc.dispose();
            ++n2;
        }
        TimeTool[] dates = svc.getLRS().getDates();
        int extra = 0;
        int colOffset = 2;
        int cLen = dates.length;
        if (dates.length > this.numColumns) {
            extra = 1;
            cLen = this.numColumns;
        }
        this.cols = new TreeViewerColumn[cLen + colOffset + extra];
        int i = 0;
        while (i < 2) {
            this.cols[i] = new TreeViewerColumn(this.tv, 0);
            this.cols[i].getColumn().setText(this.headings[i]);
            this.cols[i].getColumn().setWidth(this.widths[i]);
            ++i;
        }
        this.cols[0].setLabelProvider((CellLabelProvider)new ItemTextLabelProvider());
        this.cols[1].setLabelProvider((CellLabelProvider)new ItemRangeLabelProvider(svc.getLRS()));
        i = 0;
        while (i < cLen - extra) {
            this.cols[colOffset + i] = new TreeViewerColumn(this.tv, 0);
            this.cols[colOffset + i].getColumn().setText(dates[dates.length - 1 - i].toString(4));
            int w = this.colWidth;
            if (this.widths.length > colOffset + i) {
                w = this.widths[colOffset + i];
            }
            this.cols[colOffset + i].getColumn().setWidth(w);
            this.cols[colOffset + i].setLabelProvider((CellLabelProvider)new DateResultLabelProvider(svc, dates[dates.length - 1 - i]));
            ++i;
        }
        if (extra > 0) {
            this.cols[this.cols.length - 1] = new TreeViewerColumn(this.tv, 0);
            this.cols[this.cols.length - 1].getColumn().setText("fr\u00fcher");
            int w = this.colWidth;
            if (this.widths.length > this.cols.length - 1) {
                w = this.widths[this.cols.length - 1];
            }
            this.cols[this.cols.length - 1].getColumn().setWidth(w);
            this.cols[this.cols.length - 1].setLabelProvider((CellLabelProvider)new SmartSummaryLabelProvider(svc, dates[dates.length - cLen + 1]));
        }
    }
}

