/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller.smart;

import ch.elexis.ungrad.labview.controller.Controller;
import ch.elexis.ungrad.labview.model.LabResultsRow;
import ch.elexis.ungrad.labview.model.Result;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class SmartSummaryLabelProvider
extends StyledCellLabelProvider {
    Controller ctl;
    TimeTool limit;
    Color gray = Display.getDefault().getSystemColor(15);
    Color red = Display.getDefault().getSystemColor(3);
    Color black = Display.getDefault().getSystemColor(21);

    public SmartSummaryLabelProvider(Controller ctl, TimeTool before) {
        this.ctl = ctl;
        this.limit = before;
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof LabResultsRow) {
            LabResultsRow lr = (LabResultsRow)cell.getElement();
            Result[] minmax = lr.getBoundsBefore(this.limit);
            StringBuilder result = new StringBuilder("");
            if (minmax != null && minmax[0] != null) {
                String lower = minmax[0].get("resultat");
                StyleRange[] sr = new StyleRange[]{new StyleRange(0, lower.length(), cell.getForeground(), cell.getBackground()), new StyleRange(0, 0, cell.getForeground(), cell.getBackground())};
                if (this.ctl.getLRS().isPathologic(lr.getItem(), minmax[0])) {
                    sr[0].foreground = this.red;
                }
                result.append(lower);
                if (!minmax[0].equals(minmax[1]) && minmax[1] != null) {
                    String upper = minmax[1].get("resultat");
                    sr[1].start = lower.length() + 1;
                    sr[1].length = upper.length();
                    if (this.ctl.getLRS().isPathologic(lr.getItem(), minmax[1])) {
                        sr[1].foreground = this.red;
                    }
                    result.append("-").append(upper);
                }
                cell.setStyleRanges(sr);
            }
            cell.setText(result.toString());
            super.update(cell);
        } else {
            cell.setBackground(this.gray);
        }
    }
}

