/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller.condensed;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Patient;
import ch.elexis.ungrad.labview.controller.condensed.LabSummaryTreeColumns;
import ch.elexis.ungrad.labview.model.Bucket;
import ch.elexis.ungrad.labview.model.Item;
import ch.elexis.ungrad.labview.model.LabResultsRow;
import ch.elexis.ungrad.labview.model.LabResultsSheet;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class CondensedViewLabelProvider
extends OwnerDrawLabelProvider {
    final int padding = 8;
    LabSummaryTreeColumns ltc;
    int columnIndex;
    Color black;
    Color red;

    public CondensedViewLabelProvider(LabSummaryTreeColumns ltc, int column) {
        this.ltc = ltc;
        this.columnIndex = column;
        this.black = UiDesk.getColor((String)"schwarz");
        this.red = UiDesk.getColor((String)"rot");
    }

    protected void measure(Event event, Object element) {
        float h = this.ltc.getDefaultFont().getFontData()[0].height;
        int w = 200;
        event.setBounds(new Rectangle(event.x, event.y, w, Math.round(1.5f * h)));
    }

    protected void paint(Event event, Object element) {
        Patient actPat = ElexisEventDispatcher.getSelectedPatient();
        if (element instanceof LabResultsRow) {
            LabResultsSheet sheet = this.ltc.getLabResultsSheet();
            LabResultsRow results = (LabResultsRow)element;
            Item item = results.getItem();
            Bucket bucket = null;
            switch (this.columnIndex) {
                case 3: {
                    bucket = sheet.getRecentBucket(item);
                    break;
                }
                case 4: {
                    bucket = sheet.getOneYearBucket(item);
                    break;
                }
                case 5: {
                    bucket = sheet.getOlderBucket(item);
                    break;
                }
                default: {
                    Rectangle ct = this.centerText(event.gc, event.getBounds(), "??");
                    event.gc.drawText("??", ct.x, ct.y);
                    return;
                }
            }
            if (bucket != null) {
                GC gc = event.gc;
                Rectangle bounds = event.getBounds();
                bounds.width = this.ltc.getColumnWidth(this.columnIndex);
                String avg = bucket.getAverageResult();
                gc.setFont(this.ltc.getDefaultFont());
                Rectangle rCenter = this.centerText(gc, bounds, avg);
                gc.setForeground(item.isPathologic(actPat, avg) ? this.red : this.black);
                gc.drawText(avg, bounds.x + rCenter.x, bounds.y + rCenter.y);
                if (bucket.getResultCount() > 1) {
                    gc.setFont(this.ltc.getSmallerFont());
                    String right = bucket.getMaxResult();
                    Point ptRight = gc.textExtent(right);
                    int yOffset = rCenter.height - ptRight.y;
                    float trailingSpace = (float)bounds.width - (float)rCenter.width - (float)rCenter.x;
                    float remainingSpace = trailingSpace - (float)ptRight.x;
                    float xOffset = (float)bounds.x + (float)rCenter.x + (float)rCenter.width + remainingSpace / 2.0f;
                    gc.setForeground(item.isPathologic(actPat, right) ? this.red : this.black);
                    gc.drawText(right, Math.round(xOffset), bounds.y + rCenter.y + yOffset);
                    String left = bucket.getMinResult();
                    Point ptLeft = gc.stringExtent(left);
                    float leadingSpace = rCenter.x - ptLeft.x;
                    xOffset = leadingSpace / 2.0f;
                    gc.setForeground(item.isPathologic(actPat, left) ? this.red : this.black);
                    gc.drawText(left, Math.round((float)bounds.x + xOffset), bounds.y + rCenter.y + yOffset);
                }
            }
        } else {
            Rectangle bounds = event.getBounds();
            bounds.width = this.ltc.getColumnWidth(this.columnIndex);
            event.gc.setBackground(Display.getDefault().getSystemColor(15));
            event.gc.fillRectangle(bounds);
        }
    }

    Rectangle centerText(GC gc, Rectangle bounds, String text) {
        Point pt = gc.stringExtent(text);
        float yoffs = ((float)bounds.height - (float)pt.y) / 2.0f;
        float xoffs = ((float)bounds.width - (float)pt.x) / 2.0f;
        return new Rectangle(Math.round(xoffs), Math.round(yoffs), pt.x, pt.y);
    }
}

