/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller.condensed;

import ch.elexis.data.Patient;
import ch.elexis.ungrad.IObserver;
import ch.elexis.ungrad.labview.controller.Controller;
import ch.elexis.ungrad.labview.controller.condensed.Exporter;
import ch.elexis.ungrad.labview.controller.condensed.LabSummaryContentProvider;
import ch.elexis.ungrad.labview.controller.condensed.LabSummaryTreeColumns;
import ch.elexis.ungrad.labview.model.LabResultsSheet;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class CondensedViewController
implements IObserver {
    TreeViewer tvSummary;
    LabSummaryTreeColumns colsSummary;
    LabSummaryContentProvider lcp;
    Controller controller;

    public CondensedViewController(Controller parent) {
        this.controller = parent;
        LabResultsSheet lrs = this.controller.getLRS();
        lrs.addObserver(this);
        this.lcp = new LabSummaryContentProvider(lrs);
    }

    public TreeViewer getViewer() {
        return this.tvSummary;
    }

    public Control createControl(Composite parent) {
        this.tvSummary = new TreeViewer(parent);
        this.tvSummary.setContentProvider((IContentProvider)this.lcp);
        this.tvSummary.setUseHashlookup(true);
        Tree tree = this.tvSummary.getTree();
        this.colsSummary = new LabSummaryTreeColumns(this);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.tvSummary.setAutoExpandLevel(2);
        this.tvSummary.setInput((Object)this.lcp);
        return tree;
    }

    public void dispose() {
        this.controller.getLRS().removeObserver(this);
        this.colsSummary.dispose();
    }

    public String getState() {
        StringBuilder cw = new StringBuilder();
        int i = 0;
        while (i < this.colsSummary.cols.length) {
            cw.append(Integer.toString(this.colsSummary.cols[i].getColumn().getWidth())).append(",");
            ++i;
        }
        String widths = cw.substring(0, cw.length() - 1);
        return widths;
    }

    public void setState(String state) {
        int max = this.colsSummary.cols.length;
        int i = 0;
        String[] stringArray = state.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (i < max) {
                this.colsSummary.cols[i].getColumn().setWidth(Integer.parseInt(w));
            }
            ++n2;
        }
    }

    public Exporter getExporter() {
        return new Exporter(this.lcp);
    }

    public void signal(Object message) {
        if (message instanceof Patient) {
            this.colsSummary.reload(this.lcp);
            this.tvSummary.setInput(message);
        }
    }
}

