/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.ungrad.labview.model.Item;
import ch.elexis.ungrad.labview.model.LabResultsRow;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ItemTextLabelProvider
extends StyledCellLabelProvider {
    private Color headingsBG = Display.getDefault().getSystemColor(15);
    private Color headingsFG = UiDesk.getColor((String)"blau");
    private Color red = Display.getDefault().getSystemColor(3);

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof LabResultsRow) {
            LabResultsRow row = (LabResultsRow)cell.getElement();
            Item item = row.getItem();
            String titel = item.get("titel");
            if (row.hasRelevantResults()) {
                StyleRange sr = new StyleRange(0, titel.length(), this.red, null);
                cell.setStyleRanges(new StyleRange[]{sr});
            }
            cell.setText(titel);
            super.update(cell);
        } else if (cell.getElement() instanceof Item) {
            Item item = (Item)cell.getElement();
            cell.setText(item.get("titel"));
            super.update(cell);
        } else {
            String titel = (String)cell.getElement();
            cell.setBackground(this.headingsBG);
            cell.setForeground(this.headingsFG);
            StyleRange sr = new StyleRange(0, titel.length(), null, null, 1);
            cell.setStyleRanges(new StyleRange[]{sr});
            cell.setText(titel);
            super.update(cell);
        }
    }
}

