/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller;

import ch.elexis.ungrad.labview.controller.Controller;
import ch.elexis.ungrad.labview.model.Item;
import ch.elexis.ungrad.labview.model.LabResultsRow;
import ch.elexis.ungrad.labview.model.Result;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class DateResultLabelProvider
extends StyledCellLabelProvider {
    TimeTool myDate;
    Controller controller;
    Color red;
    Color black;
    Color gray;

    public DateResultLabelProvider(Controller ctl) {
        this.controller = ctl;
        this.gray = Display.getDefault().getSystemColor(15);
        this.red = Display.getDefault().getSystemColor(3);
        this.black = Display.getDefault().getSystemColor(21);
    }

    public DateResultLabelProvider(Controller ctl, TimeTool date) {
        this(ctl);
        this.myDate = date;
    }

    private void setDate(Controller ctl, TimeTool date) {
        this.controller = ctl;
        this.myDate = date;
    }

    private void styleCell(ViewerCell cell, Item item, Result result) {
        if (result == null) {
            cell.setText("");
        } else {
            String display = result.get("resultat");
            if (display == null) {
                display = "";
            }
            if (this.controller.getLRS().isPathologic(item, result)) {
                StyleRange sr = new StyleRange(0, display.length(), this.red, cell.getBackground());
                cell.setStyleRanges(new StyleRange[]{sr});
            }
            cell.setText(display);
        }
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof String || this.myDate == null) {
            cell.setBackground(this.gray);
        } else if (cell.getElement() instanceof LabResultsRow) {
            LabResultsRow row = (LabResultsRow)cell.getElement();
            this.styleCell(cell, row.getItem(), row.get(this.myDate));
        } else if (cell.getElement() instanceof Item) {
            Item item = (Item)cell.getElement();
            this.styleCell(cell, item, this.controller.getLRS().getResultForDate(item, this.myDate));
        }
        super.update(cell);
    }
}

