/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.ungrad.Resolver;
import ch.elexis.ungrad.labview.Preferences;
import ch.elexis.ungrad.labview.controller.condensed.CondensedViewController;
import ch.elexis.ungrad.labview.controller.condensed.Exporter;
import ch.elexis.ungrad.labview.controller.full.FullViewController;
import ch.elexis.ungrad.labview.controller.smart.SmartViewController;
import ch.elexis.ungrad.labview.model.LabResultsSheet;
import ch.elexis.ungrad.labview.views.LaborView;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    LaborView view;
    LabResultsSheet lrs = new LabResultsSheet();
    Logger log = LoggerFactory.getLogger((String)"Labview Controller");
    Resolver resolver = new Resolver();
    CondensedViewController ctlCond = new CondensedViewController(this);
    FullViewController ctlFull = new FullViewController(this);
    SmartViewController ctlSmart = new SmartViewController(this);

    public Controller(LaborView view) {
        this.view = view;
    }

    public LabResultsSheet getLRS() {
        return this.lrs;
    }

    public Control createSummaryControl(CTabFolder ctf) {
        return this.ctlCond.createControl((Composite)ctf);
    }

    public Control createFullControl(CTabFolder ctf) {
        return this.ctlFull.createControl((Composite)ctf);
    }

    public Control createSmartControl(CTabFolder ctf) {
        return this.ctlSmart.createControl((Composite)ctf);
    }

    public void saveState() {
        Preferences.cfg.set("ch.elexis.ungrad.labview.condView", this.ctlCond.getState());
        Preferences.cfg.set("ch.elexis.ungrad.labview.fullView", this.ctlFull.getState());
        Preferences.cfg.set("ch.elexis.ungrad.labview.smartView", this.ctlSmart.getState());
    }

    public void loadState() {
        String colWidths = Preferences.cfg.get("ch.elexis.ungrad.labview.condView", "150,150,100,130,130,130");
        this.ctlCond.setState(colWidths);
        this.ctlFull.setState(Preferences.cfg.get("ch.elexis.ungrad.labview.fullView", ""));
        this.ctlSmart.setState(Preferences.cfg.get("ch.elexis.ungrad.labview.smartView", ""));
    }

    public void dispose() {
        this.saveState();
        this.ctlCond.dispose();
        this.ctlFull.dispose();
        this.ctlSmart.dispose();
    }

    public void setPatient(Patient pat) throws ElexisException {
        this.lrs.setPatient(pat);
    }

    public Exporter getExporter() {
        return this.ctlCond.getExporter();
    }

    public void purgeLabItems() {
        Job job = new Job("purge lab items"){

            protected IStatus run(IProgressMonitor monitor) {
                PersistentObject.getConnection().exec("DELETE FROM LABORWERTE WHERE deleted='1'");
                PersistentObject.getConnection().exec("DELETE FROM LABORITEMS WHERE deleted='1'");
                Query qbe = new Query(LabItem.class);
                List items = qbe.execute();
                monitor.beginTask("purge unusedlab items", items.size());
                for (LabItem li : items) {
                    Query qlr = new Query(LabResult.class);
                    qlr.add("ItemID", "=", li.getId());
                    if (qlr.execute().isEmpty()) {
                        Controller.this.log.info("deleting " + li.getLabel());
                        li.delete();
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(1);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            (this).Controller.this.lrs.reload();
                        }
                        catch (ElexisException e) {
                            e.printStackTrace();
                            (this).Controller.this.log.error("could not reload Lab Items", (Throwable)e);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
    }
}

