/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labenter.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.dialogs.DateSelectorDialog;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.ungrad.labenter.views.LabEntryTable;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class ManualLabEntry
extends ViewPart
implements IActivationListener {
    public static final String ID = "ch.elexis.ungrad.labenter.views.manualentries";
    private TableViewer viewer;
    private IAction changeDateAction;
    private IAction sendValuesAction;
    private IAction clearAction;
    private TimeTool actDate = new TimeTool();
    private FormToolkit tk;
    private Form form;
    private Patient pat;
    private LabEntryTable let;
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 16){

        public void runInUi(ElexisEvent ev) {
            ManualLabEntry.this.setLabel();
        }
    };

    public void createPartControl(Composite parent) {
        this.setTitleImage(Images.IMG_EDIT.getImage());
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout(1, true));
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.setLabel();
        this.let = new LabEntryTable(this.form.getBody());
        this.viewer = this.let.viewer;
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    private void setLabel() {
        this.pat = ElexisEventDispatcher.getSelectedPatient();
        String lab = this.pat == null ? "Kein Patient gew\u00e4hlt" : this.pat.getLabel();
        this.form.setText("Labor von " + lab + ", vom " + this.actDate.toString(4));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ManualLabEntry.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.changeDateAction);
        manager.add(this.sendValuesAction);
        manager.add(this.clearAction);
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.changeDateAction);
        manager.add(this.sendValuesAction);
        manager.add(this.clearAction);
    }

    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat});
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat});
        }
    }

    private void clearFields() {
        LabEntryTable.Element[] elementArray = this.let.elements;
        int n = this.let.elements.length;
        int n2 = 0;
        while (n2 < n) {
            LabEntryTable.Element el = elementArray[n2];
            el.value = "";
            ++n2;
        }
        this.viewer.setInput((Object)this.let.elements);
    }

    private void makeActions() {
        this.changeDateAction = new Action(){
            {
                this.setText("Anderes Datum");
                this.setToolTipText("Datum f\u00fcr diese Laborwerte eingeben");
                this.setImageDescriptor(Images.IMG_CALENDAR.getImageDescriptor());
            }

            public void run() {
                DateSelectorDialog dsl = new DateSelectorDialog(ManualLabEntry.this.getViewSite().getShell());
                if (dsl.open() == 0) {
                    ManualLabEntry.this.actDate = dsl.getSelectedDate();
                    ManualLabEntry.this.setLabel();
                }
            }
        };
        this.sendValuesAction = new Action(){
            {
                this.setText("Absenden");
                this.setToolTipText("Diese Werte speichern");
                this.setImageDescriptor(Images.IMG_EDIT_DONE.getImageDescriptor());
            }

            public void run() {
                if (ManualLabEntry.this.pat == null) {
                    ManualLabEntry.this.showMessage("Es ist kein Patient ausgew\u00e4hlt");
                } else if (SWTHelper.askYesNo((String)"Daten eintragen", (String)("Wirklich die Daten f\u00fcr\n\n" + ManualLabEntry.this.pat.getLabel() + ", Datum " + ManualLabEntry.this.actDate.toString(4) + "\n\neintragen?"))) {
                    BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LabEntryTable.Element[] elementArray = ((ManualLabEntry)(this).ManualLabEntry.this).let.elements;
                            int n = ((ManualLabEntry)(this).ManualLabEntry.this).let.elements.length;
                            int n2 = 0;
                            while (n2 < n) {
                                LabEntryTable.Element el = elementArray[n2];
                                if (!el.value.isEmpty()) {
                                    new LabResult(ManualLabEntry.this.pat, ManualLabEntry.this.actDate, el.item, el.value, "");
                                }
                                ++n2;
                            }
                            ManualLabEntry.this.showMessage("ok");
                            ManualLabEntry.this.clearFields();
                        }
                    });
                }
            }
        };
        this.clearAction = new Action(){
            {
                this.setText("Alles l\u00f6schen");
                this.setToolTipText("Formulareingaben leeren");
                this.setImageDescriptor(Images.IMG_CLEAR.getImageDescriptor());
            }

            public void run() {
                ManualLabEntry.this.clearFields();
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Laboreingabe", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void activation(boolean mode) {
    }
}

