/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.forms.model;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.ungrad.Resolver;
import ch.rgw.tools.StringTool;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Template {
    private String html;
    Document doc;
    String title = "";
    String heading = "";
    String doctype = "";
    String mailSender = "";
    String mailBody = "";
    String mailSubject = "";
    String mailRecipient = "";
    String filename;
    private Kontakt adressat = null;
    Map<String, String> inputs = new LinkedHashMap<String, String>();

    public Template(String rawhtml, Kontakt adressat) throws Exception {
        Element eDoctype;
        Element eAnrede;
        Element eHeader;
        HashMap<String, Kontakt> replacer = new HashMap<String, Kontakt>();
        if (adressat != null) {
            this.adressat = adressat;
            replacer.put("Adressat", adressat);
        }
        Resolver resolver = new Resolver(replacer, true);
        this.html = resolver.resolve(rawhtml);
        this.doc = Jsoup.parse((String)this.html);
        Document.OutputSettings outs = this.doc.outputSettings();
        outs.prettyPrint(false);
        outs.syntax(Document.OutputSettings.Syntax.xml);
        Elements els = this.doc.getElementsByTag("title");
        Element eTitle = els.first();
        if (eTitle != null) {
            this.title = eTitle.text();
        }
        if ((eHeader = (els = this.doc.getElementsByTag("h1")).first()) != null) {
            this.heading = eHeader.text();
        }
        if ((eAnrede = (els = this.doc.getElementsByAttribute("data-anrede")).first()) != null && adressat != null) {
            String bem = adressat.getBemerkung();
            Pattern pat = Pattern.compile(":Anrede:([^:]+):");
            Matcher m = pat.matcher(bem);
            if (m.find()) {
                String anrede = m.group(1);
                eAnrede.html(anrede);
                this.html = this.doc.html();
            }
        }
        if ((eDoctype = (els = this.doc.getElementsByAttribute("data-doctype")).first()) != null) {
            this.doctype = eDoctype.attr("data-doctype");
        }
        if ((eTitle = (els = this.doc.getElementsByAttribute("data-doctitle")).first()) != null) {
            this.title = eTitle.attr("data-doctitle");
        }
        if (StringTool.isNothing((Object)this.title)) {
            this.title = this.heading;
        }
        if (StringTool.isNothing((Object)this.title)) {
            this.title = this.doctype;
        }
        els = this.doc.getElementsByAttribute("data-input");
        for (Element input : els) {
            this.inputs.put(input.attr("data-input"), input.html());
        }
        els = this.doc.getElementsByAttribute("data-mail");
        for (Element mailpart : els) {
            String type = mailpart.attr("data-mail");
            if (type.equals("sender")) {
                this.mailSender = mailpart.text();
                continue;
            }
            if (type.equals("body")) {
                this.mailBody = mailpart.html();
                continue;
            }
            if (type.equals("subject")) {
                this.mailSubject = mailpart.text();
                continue;
            }
            if (!type.equals("recipient")) continue;
            this.mailRecipient = mailpart.text();
        }
    }

    public Kontakt getAdressat() {
        Element body = this.doc.body();
        Element eAdressat = body.getElementById("x-adressat");
        if (eAdressat == null) {
            if (this.adressat == null) {
                Brief brief = this.getBrief();
                if (brief != null) {
                    this.setAdressat(brief.getAdressat());
                }
            } else {
                this.setAdressat(this.adressat);
            }
        } else {
            String id = eAdressat.attr("data-id");
            Kontakt ka = Kontakt.load((String)id);
            if (ka.isValid()) {
                this.adressat = ka;
            }
        }
        return this.adressat;
    }

    public void setAdressat(Kontakt adr) {
        if (this.adressat != null && this.adressat.isValid()) {
            this.adressat = adr;
            Element eAdressat = this.doc.getElementById("x-adressat");
            if (eAdressat == null) {
                this.doc.body().append("<span id=\"x-adressat\" data-id=\"" + this.adressat.getId() + "\"></span>");
            } else {
                eAdressat.attr("data-id", this.adressat.getId());
            }
            this.html = this.doc.html();
        }
    }

    public void setBrief(Brief brief) {
        Element body = this.doc.body();
        Element eBrief = body.getElementById("x-brief");
        if (eBrief == null) {
            body.append("<span id=\"x-brief\" data-id=\"" + brief.getId() + "\"></span>");
        } else {
            eBrief.attr("data-id", brief.getId());
        }
        this.html = this.doc.html();
    }

    public Brief getBrief() {
        String bid;
        Brief ret;
        Element body = this.doc.body();
        Element eBrief = body.getElementById("x-brief");
        if (eBrief != null && (ret = Brief.load((String)(bid = eBrief.attr("data-id")))).isValid()) {
            return ret;
        }
        return null;
    }

    public String getMailSender() {
        return this.mailSender;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public String getMailBody() {
        if (StringTool.isNothing((Object)this.mailBody)) {
            return CoreHub.localCfg.get("ch.elexis.ungrad.forms/defaultMailBody", "Siehe Anhang");
        }
        return this.mailBody;
    }

    public String getMailRecipient() {
        this.adressat = this.getAdressat();
        if (this.adressat == null) {
            return this.mailRecipient;
        }
        String ret = this.adressat.get("E-Mail");
        if (StringTool.isNothing((Object)ret)) {
            return this.mailRecipient;
        }
        return ret;
    }

    public void setInput(String key, String value) {
        this.inputs.put(key, value);
        Elements els = this.doc.getElementsByAttributeValue("data-input", key);
        els.html(value);
        this.html = this.doc.html();
    }

    public void replace(String orig, String replacement) {
        this.html = this.doc.html().replace(orig, replacement);
        this.doc = Jsoup.parse((String)this.html);
    }

    public String getXml() {
        Document.OutputSettings settings = this.doc.outputSettings();
        settings.syntax(Document.OutputSettings.Syntax.xml);
        this.doc.outputSettings(settings);
        return this.doc.html();
    }

    public String getDoctype() {
        return this.doctype;
    }

    public String getTitle() {
        return this.title;
    }

    public Map<String, String> getInputs() {
        return this.inputs;
    }

    public void setFilename(String absoluteFile) {
        this.filename = absoluteFile;
    }

    public String getFilename() {
        return this.filename;
    }
}

