/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.Util;
import ch.rgw.io.FileTool;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class Mailer {
    String sender;
    String smtpHost;
    String smtpPassword;
    String smtpPort;

    public Mailer(String from, String smtpHost, String smtpPassword, String smtpPort) {
        this.sender = from;
        this.smtpHost = smtpHost;
        this.smtpPassword = smtpPassword;
        this.smtpPort = smtpPort;
    }

    public void sendEmail(Session session, String toEmail, String subject, String body, String[] attachments) throws Exception {
        MimeMessage msg = new MimeMessage(session);
        msg.addHeader("Content-type", "text/html; charset=UTF-8");
        msg.addHeader("format", "flowed");
        msg.addHeader("Content-Transfer-Encoding", "8bit");
        msg.setFrom((Address)new InternetAddress(this.sender));
        msg.addRecipient(MimeMessage.RecipientType.BCC, msg.getFrom()[0]);
        msg.setReplyTo(msg.getFrom());
        msg.setSubject(subject, "UTF-8");
        if (attachments != null) {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            if (body.contains("<")) {
                messageBodyPart.setContent((Object)body, "text/html; charset=UTF-8");
            } else {
                messageBodyPart.setText(body);
            }
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            String[] stringArray = attachments;
            int n = attachments.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(filename);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(Util.reduceCharset(FileTool.getFilename((String)filename)));
                multipart.addBodyPart((BodyPart)messageBodyPart);
                ++n2;
            }
            msg.setContent((Multipart)multipart);
        } else {
            msg.setText(body, "UTF-8");
        }
        msg.setSentDate(new Date());
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toEmail, (boolean)false));
        SendJob sendJob = new SendJob(msg, toEmail);
        sendJob.setUser(true);
        sendJob.schedule();
    }

    public void simpleMail(String to, String subject, String body, String[] attachments) throws Exception {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", this.smtpHost);
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.port", this.smtpPort);
        Session session = Session.getInstance((Properties)props, null);
        this.sendEmail(session, to, subject, body, attachments);
    }

    public void tlsMail(final String user, String to, String subject, String body, String[] attachments) throws Exception {
        System.out.println("TLSEmail Start");
        Properties props = new Properties();
        props.put("mail.smtp.host", this.smtpHost);
        props.put("mail.smtp.port", this.smtpPort);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, Mailer.this.smtpPassword);
            }
        };
        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
        this.sendEmail(session, to, subject, body, attachments);
    }

    public void sslMail(final String user, String to, String subject, String body, String[] attachments) throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.smtpHost);
        props.put("mail.smtp.socketFactory.port", this.smtpPort);
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.port", this.smtpPort);
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, Mailer.this.smtpPassword);
            }
        };
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
        System.out.println("Session created");
        this.sendEmail(session, to, subject, body, attachments);
    }

    class SendJob
    extends Job {
        private MimeMessage msg;
        private String address;

        public SendJob(MimeMessage msg, String adr) {
            super("Send Mail");
            this.msg = msg;
            this.address = adr;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("Sending mail " + this.msg.getMessageID(), 1);
                Transport.send((Message)this.msg);
                monitor.done();
                SWTHelper.showInfo((String)"Mail gesendet", (String)("Die Mail wurde an " + this.address + " gesendet."));
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                SWTHelper.showError((String)"SMTP Mailer", (String)ex.getMessage());
                return new Status(4, "Mailer", ex.getMessage());
            }
        }
    }
}

