/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import ch.elexis.ungrad.IMAPMail;
import ch.rgw.io.FileTool;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class MBox {
    private final File mbox;
    private Session session;
    private String[] whitelist;
    private TimeTool today;

    public MBox(String file, String[] whitelist) throws Exception {
        this.mbox = new File(file);
        if (!(this.mbox.exists() && this.mbox.isFile() && this.mbox.canRead())) {
            throw new Exception("Can't read mbox");
        }
        this.whitelist = whitelist;
        this.session = Session.getDefaultInstance((Properties)new Properties());
        this.today = new TimeTool();
    }

    public void readMessages(IMAPMail.INotifier notifier) throws Exception {
        FileInputStream in = new FileInputStream(this.mbox);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder msg = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("From ") && msg.length() > 0) {
                this.process(msg.toString(), notifier);
                msg.setLength(0);
            }
            msg.append(line).append("\r\n");
        }
        if (msg.length() > 0) {
            this.process(msg.toString(), notifier);
        }
    }

    private void process(String sMsg, IMAPMail.INotifier notifier) throws Exception {
        InternetAddress[] iadr;
        String sender;
        StringBufferInputStream strin = new StringBufferInputStream(sMsg);
        MimeMessage m = new MimeMessage(this.session, (InputStream)strin);
        Date sent = m.getSentDate();
        Date received = m.getReceivedDate();
        TimeTool date = new TimeTool();
        if (received != null) {
            date = new TimeTool(received);
        } else if (sent != null) {
            date = new TimeTool(sent);
        }
        Address[] from = m.getFrom();
        if (from.length == 0) {
            from = m.getReplyTo();
        }
        if (from.length > 0 && (sender = this.findSender(iadr = (InternetAddress[])from)) != null) {
            System.out.println(String.valueOf(sender) + ", " + date.toString(4));
            if (date.isSameDay(this.today)) {
                String subject = m.getSubject();
                this.saveParts(m.getContent(), notifier, sender, subject);
            }
        }
    }

    String findSender(InternetAddress[] addr) {
        String ret = null;
        Object[] objectArray = addr;
        int n = addr.length;
        int n2 = 0;
        while (n2 < n) {
            InternetAddress adr = objectArray[n2];
            if (adr.getAddress().contains("@")) {
                ret = adr.getAddress();
                break;
            }
            ++n2;
        }
        if (this.whitelist == null || this.whitelist.length == 0) {
            return ret;
        }
        objectArray = this.whitelist;
        n = this.whitelist.length;
        n2 = 0;
        while (n2 < n) {
            InternetAddress wl = objectArray[n2];
            String[] w = wl.split(":");
            if (w[0].startsWith("@")) {
                int idx = ret.indexOf("@");
                if (w[0].substring(1).equalsIgnoreCase(ret.substring(idx + 1))) {
                    return w.length == 2 ? w[1] : ret;
                }
            } else if (w[0].equalsIgnoreCase(ret)) {
                return w.length == 2 ? w[1] : ret;
            }
            ++n2;
        }
        return null;
    }

    void saveParts(Object content, IMAPMail.INotifier notifier, String sender, String subject) throws Exception {
        if (content instanceof Multipart) {
            Multipart multi = (Multipart)content;
            int parts = multi.getCount();
            int j = 0;
            while (j < parts) {
                MimeBodyPart part = (MimeBodyPart)multi.getBodyPart(j);
                if (part.getContent() instanceof Multipart) {
                    this.saveParts(part.getContent(), notifier, sender, subject);
                } else {
                    String f2;
                    String fn = part.getFileName();
                    if (!StringTool.isNothing((Object)fn) && (f2 = MimeUtility.decodeText((String)fn)).toLowerCase().endsWith("pdf")) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        InputStream is = part.getInputStream();
                        FileTool.copyStreams((InputStream)is, (OutputStream)baos);
                        notifier.documentFound(f2, baos.toByteArray(), sender, subject);
                    }
                }
                ++j;
            }
        }
    }
}

