/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad;

import ch.elexis.core.data.activator.CoreHub;
import ch.rgw.io.FileTool;
import ch.rgw.tools.StringTool;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class IMAPMail {
    private String[] whitelist;
    Folder folder;
    Session session;
    Store store;
    long uidvalidity;
    long lastseen;
    INotifier notifier;

    public IMAPMail(String[] whitelist, INotifier notify) {
        this.whitelist = whitelist;
        this.notifier = notify;
    }

    public void fetch() throws Exception {
        new HashMap();
        String host = CoreHub.localCfg.get("ch.elexis.ungrad.common/imapHost", "");
        String user = CoreHub.localCfg.get("ch.elexis.ungrad.common/imapUser", "");
        String pwd = CoreHub.localCfg.get("ch.elexis.ungrad.common/imapPwd", "");
        this.uidvalidity = Long.parseLong(CoreHub.localCfg.get("ch.elexis.ungrad.common/imapUIDValidity", "0"));
        this.lastseen = Long.parseLong(CoreHub.localCfg.get("ch.elexis.ungrad.common/imapLastSeen", "1"));
        Properties props = System.getProperties();
        props.setProperty("mail.store.protocol", "imaps");
        this.session = Session.getDefaultInstance((Properties)props, null);
        this.store = this.session.getStore("imaps");
        this.store.connect(host, user, pwd);
        this.folder = this.store.getFolder("Inbox");
        if (this.folder.exists()) {
            FetchJob fetcher = new FetchJob();
            fetcher.setUser(true);
            fetcher.schedule();
        }
    }

    String findSender(InternetAddress[] addr) {
        String ret = null;
        Object[] objectArray = addr;
        int n = addr.length;
        int n2 = 0;
        while (n2 < n) {
            InternetAddress adr = objectArray[n2];
            if (adr.getAddress().contains("@")) {
                ret = adr.getAddress();
                break;
            }
            ++n2;
        }
        if (this.whitelist == null || this.whitelist.length == 0) {
            return ret;
        }
        objectArray = this.whitelist;
        n = this.whitelist.length;
        n2 = 0;
        while (n2 < n) {
            InternetAddress wl = objectArray[n2];
            String[] w = wl.split(":");
            if (w[0].startsWith("@")) {
                int idx = ret.indexOf("@");
                if (w[0].substring(1).equalsIgnoreCase(ret.substring(idx + 1))) {
                    return w.length == 2 ? w[1] : ret;
                }
            } else if (w[0].equalsIgnoreCase(ret)) {
                return w.length == 2 ? w[1] : ret;
            }
            ++n2;
        }
        return null;
    }

    void saveParts(Object content, String sender, String subject) throws Exception {
        if (content instanceof Multipart) {
            Multipart multi = (Multipart)content;
            int parts = multi.getCount();
            int j = 0;
            while (j < parts) {
                MimeBodyPart part = (MimeBodyPart)multi.getBodyPart(j);
                if (part.getContent() instanceof Multipart) {
                    this.saveParts(part.getContent(), sender, subject);
                } else {
                    String f2;
                    String f3;
                    String fn = part.getFileName();
                    if (!StringTool.isNothing((Object)fn) && (f3 = (f2 = MimeUtility.decodeText((String)fn)).toLowerCase()).matches(".+\\.(jpe?g|pdf)")) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        InputStream is = part.getInputStream();
                        FileTool.copyStreams((InputStream)is, (OutputStream)baos);
                        this.notifier.documentFound(f2, baos.toByteArray(), sender, subject);
                    }
                }
                ++j;
            }
        }
    }

    class FetchJob
    extends Job {
        public FetchJob() {
            super("Import Imap Mails");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IMAPMail.this.folder.open(1);
                UIDFolder uf = (UIDFolder)IMAPMail.this.folder;
                long uid = uf.getUIDValidity();
                if (uid != IMAPMail.this.uidvalidity) {
                    IMAPMail.this.lastseen = 1L;
                    IMAPMail.this.uidvalidity = uid;
                    CoreHub.localCfg.set("ch.elexis.ungrad.common/imapUIDValidity", Long.toString(IMAPMail.this.uidvalidity, 10));
                    CoreHub.localCfg.flush();
                }
                Message[] messages = uf.getMessagesByUID(IMAPMail.this.lastseen + 1L, -1L);
                monitor.beginTask("Reading IMAP", messages.length);
                int i = 0;
                while (i < messages.length) {
                    InternetAddress[] iadr;
                    String sender;
                    Message msg = messages[i];
                    System.out.println(uf.getUID(msg));
                    Address[] from = msg.getFrom();
                    if (from.length == 0) {
                        from = msg.getReplyTo();
                    }
                    if (from.length > 0 && (sender = IMAPMail.this.findSender(iadr = (InternetAddress[])from)) != null) {
                        System.out.println(String.valueOf(sender) + " " + msg.getMessageNumber());
                        String subject = msg.getSubject();
                        IMAPMail.this.saveParts(msg.getContent(), sender, subject);
                    }
                    IMAPMail.this.lastseen = uf.getUID(msg);
                    CoreHub.localCfg.set("ch.elexis.ungrad.common/imapLastSeen", Long.toString(IMAPMail.this.lastseen, 10));
                    CoreHub.localCfg.flush();
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IMAPMail.this.folder.close(false);
                        IMAPMail.this.store.close();
                        return Status.CANCEL_STATUS;
                    }
                    ++i;
                }
                IMAPMail.this.folder.close(false);
                IMAPMail.this.store.close();
                monitor.done();
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                return new Status(4, "Imapmail", ex.getMessage());
            }
        }
    }

    public static interface INotifier {
        public void documentFound(String var1, byte[] var2, String var3, String var4);
    }
}

