/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.risch;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.ui.importer.div.importers.DefaultHL7Parser;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class Importer
extends ImporterPage {
    public static final String MY_LAB = "Risch";
    public static final String PLUGIN_ID = "ch.elexis.laborimport_risch";
    private static final String OPENMEDICAL_MAINCLASS = "ch.openmedical.JMedTransfer.JMedTransfer";
    private HL7Parser hlp = new DefaultHL7Parser("Risch");
    private static final int FILE = 1;
    private static final int DIRECT = 2;
    private Object openmedicalObject = null;
    private Method openmedicalDownloadMethod = null;

    public Importer() {
        System.out.println("here");
    }

    private static URLClassLoader getURLClassLoader(URL jarURL) {
        return new URLClassLoader(new URL[]{jarURL});
    }

    public Composite createPage(Composite parent) {
        File jar;
        String jarPath = CoreHub.localCfg.get("risch/jar_path", null);
        if (jarPath != null && (jar = new File(jarPath)).canRead()) {
            try {
                URLClassLoader urlLoader = Importer.getURLClassLoader(new URL("file", null, jar.getAbsolutePath()));
                Class<?> openmedicalClass = urlLoader.loadClass(OPENMEDICAL_MAINCLASS);
                Method meth = openmedicalClass.getMethod("download", String[].class);
                Object obj = openmedicalClass.newInstance();
                this.openmedicalObject = obj;
                this.openmedicalDownloadMethod = meth;
            }
            catch (Throwable throwable) {}
        }
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        LabImporter labImporter = new LabImporter(ret, this);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        labImporter.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        return ret;
    }

    private Result<?> importDirect() {
        File downloadDir;
        if (this.openmedicalObject == null) {
            return new Result(Result.SEVERITY.ERROR, 1, MY_LAB, (Object)"Fehlerhafte Konfiguration", true);
        }
        Result result = new Result((Object)"OK");
        String downloadDirPath = CoreHub.localCfg.get("risch/downloaddir", CoreHub.getTempDir().toString());
        String iniPath = CoreHub.localCfg.get("risch/ini_path", null);
        int res = -1;
        if (iniPath != null) {
            try {
                Object omResult = this.openmedicalDownloadMethod.invoke(this.openmedicalObject, new Object[]{new String[]{"--download", downloadDirPath, "--logPath", downloadDirPath, "--ini", iniPath, "--verbose", "INF", "-#OpenMedicalKey#"}});
                if (omResult instanceof Integer) {
                    res = (Integer)omResult;
                    System.out.println(String.valueOf(res) + " files downoladed");
                    if (res < 1) {
                        SWTHelper.showInfo((String)"Verbindung mit Labor Risch erfolgreich", (String)"Es sind keine Resultate zum Abholen vorhanden");
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        if ((downloadDir = new File(downloadDirPath)).isDirectory()) {
            String[] files;
            File archiveDir = new File(downloadDir, "archive");
            if (!archiveDir.exists()) {
                archiveDir.mkdir();
            }
            String[] stringArray = files = downloadDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File path, String name) {
                    return name.toLowerCase().endsWith(".hl7");
                }
            });
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File f = new File(downloadDir, file);
                try {
                    this.hlp.importFile(f, archiveDir, false);
                }
                catch (IOException e) {
                    SWTHelper.showError((String)"Import error", (String)e.getMessage());
                }
                ++n2;
            }
            SWTHelper.showInfo((String)"Verbindung mit Labor Risch erfolgreich", (String)("Es wurden " + Integer.toString(res) + " Dateien verarbeitet"));
        } else {
            SWTHelper.showError((String)"Falsches Verzeichnis", (String)"Bitte kontrollieren Sie die Einstellungen f\u00fcr das Download-Verzeichnis");
            result = new Result(Result.SEVERITY.ERROR, 1, MY_LAB, (Object)"Fehlerhafte Konfiguration", true);
        }
        return result;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        int type;
        try {
            String sType = this.results[0];
            type = Integer.parseInt(sType);
        }
        catch (NumberFormatException numberFormatException) {
            type = 1;
        }
        if (type != 1 && type != 2) {
            type = 1;
        }
        if (type == 1) {
            String filename = this.results[1];
            return ResultAdapter.getResultAsStatus((Result)this.hlp.importFile(filename, false));
        }
        return ResultAdapter.getResultAsStatus(this.importDirect());
    }

    public String getDescription() {
        return "Bitte w\u00e4hlen Sie eine Datei im HL7-Format oder die Direkt\u00fcbertragung zum Import aus";
    }

    public String getTitle() {
        return "Labor Risch";
    }

    String getBasePath() {
        try {
            URL url = Platform.getBundle((String)PLUGIN_ID).getEntry("/");
            url = FileLocator.toFileURL((URL)url);
            String bundleLocation = url.getPath();
            File file = new File(bundleLocation);
            bundleLocation = file.getAbsolutePath();
            return bundleLocation;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private class LabImporter
    extends Composite {
        private final Button bFile;
        private final Button bDirect;
        private final Text tFilename;

        public LabImporter(final Composite parent, final ImporterPage home) {
            super(parent, 2048);
            this.setLayout((Layout)new GridLayout(3, false));
            this.bFile = new Button((Composite)this, 16);
            this.bFile.setText("Import aus Datei (HL7)");
            this.bFile.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            Label lFile = new Label((Composite)this, 0);
            GridData gd = SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false);
            gd.horizontalAlignment = 3;
            gd.widthHint = lFile.getSize().x + 20;
            this.tFilename = new Text((Composite)this, 2048);
            this.tFilename.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Button bBrowse = new Button((Composite)this, 8);
            this.bDirect = new Button((Composite)this, 16);
            this.bDirect.setText("Direkter Import");
            this.bDirect.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            int type = CoreHub.localCfg.get("ImporterPage/" + home.getTitle() + "/type", 1);
            if (Importer.this.openmedicalObject == null) {
                type = 1;
            }
            home.results = new String[2];
            if (type == 1) {
                this.bFile.setSelection(true);
                this.bDirect.setSelection(false);
                String filename = CoreHub.localCfg.get("ImporterPage/" + home.getTitle() + "/filename", "");
                this.tFilename.setText(filename);
                home.results[0] = new Integer(1).toString();
                home.results[1] = filename;
            } else {
                this.bFile.setSelection(false);
                this.bDirect.setSelection(true);
                this.tFilename.setText("");
                home.results[0] = new Integer(2).toString();
                home.results[1] = "";
            }
            if (Importer.this.openmedicalObject == null) {
                this.bDirect.setEnabled(false);
            }
            SelectionAdapter sa = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    if (!button.getSelection()) {
                        return;
                    }
                    int type = 1;
                    if (button == LabImporter.this.bFile) {
                        type = 1;
                    } else if (button == LabImporter.this.bDirect) {
                        type = 2;
                    }
                    if (type == 1) {
                        LabImporter.this.bFile.setSelection(true);
                        LabImporter.this.bDirect.setSelection(false);
                        String filename = LabImporter.this.tFilename.getText();
                        home.results[0] = new Integer(1).toString();
                        home.results[1] = filename;
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/type", 1);
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/filename", filename);
                    } else {
                        LabImporter.this.bFile.setSelection(false);
                        LabImporter.this.bDirect.setSelection(true);
                        LabImporter.this.tFilename.setText("");
                        home.results[0] = new Integer(2).toString();
                        home.results[1] = "";
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/type", 2);
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/filename", "");
                    }
                }
            };
            this.bFile.addSelectionListener((SelectionListener)sa);
            this.bDirect.addSelectionListener((SelectionListener)sa);
            bBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LabImporter.this.bFile.setSelection(true);
                    LabImporter.this.bDirect.setSelection(false);
                    FileDialog fdl = new FileDialog(parent.getShell(), 4096);
                    fdl.setFilterExtensions(new String[]{"*"});
                    String filename = fdl.open();
                    if (filename == null) {
                        filename = "";
                    }
                    LabImporter.this.tFilename.setText(filename);
                    home.results[0] = new Integer(1).toString();
                    home.results[1] = filename;
                    CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/type", 1);
                    CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/filename", filename);
                }
            });
        }
    }
}

