/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.sftp;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Messages;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.ui.importer.div.importers.DefaultHL7Parser;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.laborimport.sftp.JschUserInfo;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SftpImporter
extends ImporterPage {
    public static final String MY_LAB = CoreHub.localCfg.get("LABORNAME", "<unbekannt>");
    public static final String PLUGIN_ID = "ch.elexis.laborimport.sftp";
    private static final int FILE = 1;
    private static final int DIRECT = 2;
    private HL7Parser hlp = new DefaultHL7Parser(MY_LAB);
    Shell parentShell;

    public Composite createPage(Composite parent) {
        this.parentShell = parent.getShell();
        LabImporter labImporter = new LabImporter(parent, this);
        labImporter.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        return labImporter;
    }

    private Result<?> importDirect() {
        final Result result = new Result((Object)"OK");
        String downloadDirPath = CoreHub.localCfg.get("labor/sftp/downloaddir", CoreHub.getTempDir().toString());
        String pwd = CoreHub.localCfg.get("labor/sftp/password", null);
        final String host = CoreHub.localCfg.get("labor/sftp/ftp_url", null);
        final String user = CoreHub.localCfg.get("labor/sftp/username", null);
        final File downloadDir = new File(downloadDirPath);
        final File archiveDir = new File(downloadDir, "archive");
        if (!archiveDir.exists()) {
            archiveDir.mkdir();
        }
        if (pwd != null && user != null && host != null) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSch jsch = new JSch();
                            int port = CoreHub.localCfg.get("labor/sftp/ftp_port", 22);
                            Session session = jsch.getSession(user, host, port);
                            JschUserInfo ui = new JschUserInfo();
                            session.setUserInfo((UserInfo)ui);
                            session.connect();
                            Channel channel = session.openChannel("sftp");
                            channel.connect();
                            ChannelSftp c = (ChannelSftp)channel;
                            SftpImporter.this.log.log("SFTP Version " + c.version(), 4);
                            Vector vv = c.ls(".");
                            int count = 0;
                            int err = 0;
                            if (vv != null) {
                                for (ChannelSftp.LsEntry entry : vv) {
                                    Result r;
                                    String fname = entry.getFilename();
                                    if (fname.matches("\\.\\.?")) continue;
                                    if (!fname.matches("[a-zA-Z0-9_\\-\\.\\/]+")) {
                                        result.add(new Result(Result.SEVERITY.WARNING, 2, "Dateiname " + fname + " enth\u00e4lt ung\u00fcltige Zeichen", null, true));
                                        ++err;
                                        continue;
                                    }
                                    SftpImporter.this.log.log(entry.getLongname(), 4);
                                    File localFile = new File(downloadDir, entry.getFilename());
                                    try {
                                        c.get(entry.getFilename(), localFile.getAbsolutePath());
                                        r = SftpImporter.this.hlp.importFile(localFile, archiveDir, false);
                                    }
                                    catch (Exception ex) {
                                        ExHandler.handle((Throwable)ex);
                                        ++err;
                                        r = new Result(Result.SEVERITY.WARNING, 1, "Fehler beim Import von " + entry.getFilename(), (Object)localFile.getAbsolutePath(), true);
                                    }
                                    result.add(r);
                                    if (r.isOK()) {
                                        if (CoreHub.localCfg.get("labor/sftp/deletereceived", true)) {
                                            c.rm(entry.getFilename());
                                        }
                                        ++count;
                                        continue;
                                    }
                                    ++err;
                                }
                            }
                            c.quit();
                            session.disconnect();
                            SWTHelper.showInfo((String)"Import beendet", (String)("Es wurden " + count + " Dateien importiert.\nBei " + err + " Dateien sind Fehler aufgetreten."));
                            if (!result.isOK()) {
                                ResultAdapter.displayResult((Result)result, (String)"Fehlermeldungen: ");
                            }
                        }
                        catch (SftpException sfex) {
                            SWTHelper.showError((String)"SFTP Fehler", (String)sfex.getMessage());
                        }
                        catch (JSchException jshex) {
                            SWTHelper.showError((String)"Jsch Fehler", (String)jshex.getMessage());
                        }
                    }
                });
            }
            catch (Throwable e) {
                SWTHelper.showError((String)"Fehler bei Badena Import", (String)"Es ist ein Fehler aufgetreten", (String)e.getMessage());
            }
        }
        return result;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        int type;
        try {
            String sType = this.results[0];
            type = Integer.parseInt(sType);
        }
        catch (NumberFormatException numberFormatException) {
            type = 1;
        }
        if (type != 1 && type != 2) {
            type = 1;
        }
        if (type == 1) {
            String filename = this.results[1];
            return ResultAdapter.getResultAsStatus((Result)this.hlp.importFile(filename, false));
        }
        return ResultAdapter.getResultAsStatus(this.importDirect());
    }

    public String getDescription() {
        return "Bitte w\u00e4hlen Sie eine Datei im HL7-Format oder die Direkt\u00fcbertragung zum Import aus";
    }

    public String getTitle() {
        return "Labor " + MY_LAB;
    }

    private class LabImporter
    extends Composite {
        private final Button bFile;
        private final Button bDirect;
        private final Button bBrowse;
        private final Text tFilename;

        public LabImporter(final Composite parent, final ImporterPage home) {
            super(parent, 2048);
            this.setLayout((Layout)new GridLayout(3, false));
            this.bFile = new Button((Composite)this, 16);
            this.bFile.setText("Import aus Datei (HL7)");
            this.bFile.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            Label lFile = new Label((Composite)this, 0);
            lFile.setText("    " + Messages.ImporterPage_file);
            GridData gd = SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false);
            gd.horizontalAlignment = 3;
            gd.widthHint = lFile.getSize().x + 20;
            this.tFilename = new Text((Composite)this, 2048);
            this.tFilename.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            this.bBrowse = new Button((Composite)this, 8);
            this.bBrowse.setText(Messages.ImporterPage_browse);
            this.bDirect = new Button((Composite)this, 16);
            this.bDirect.setText("Direkter Import");
            this.bDirect.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
            int type = CoreHub.localCfg.get("ImporterPage/" + home.getTitle() + "/type", 1);
            home.results = new String[2];
            String filename = CoreHub.localCfg.get("ImporterPage/" + home.getTitle() + "/filename", "");
            this.tFilename.setText(filename);
            home.results[1] = filename;
            if (type == 1) {
                this.bFile.setSelection(true);
                this.bDirect.setSelection(false);
                this.tFilename.setEnabled(true);
                this.bBrowse.setEnabled(true);
                home.results[0] = new Integer(1).toString();
            } else {
                this.bFile.setSelection(false);
                this.bDirect.setSelection(true);
                this.bBrowse.setEnabled(false);
                this.tFilename.setEnabled(false);
                home.results[0] = new Integer(2).toString();
            }
            if (CoreHub.localCfg.get("labor/sftp/password", null) == null) {
                this.bDirect.setEnabled(false);
            }
            SelectionAdapter sa = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    if (!button.getSelection()) {
                        return;
                    }
                    if (button == LabImporter.this.bFile) {
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/type", 1);
                        LabImporter.this.bBrowse.setEnabled(true);
                        LabImporter.this.tFilename.setEnabled(true);
                        LabImporter.this.bFile.setSelection(true);
                    } else if (button == LabImporter.this.bDirect) {
                        CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/type", 2);
                        LabImporter.this.bBrowse.setEnabled(false);
                        LabImporter.this.bDirect.setSelection(true);
                        LabImporter.this.tFilename.setEnabled(false);
                    }
                }
            };
            this.bFile.addSelectionListener((SelectionListener)sa);
            this.bDirect.addSelectionListener((SelectionListener)sa);
            this.bBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LabImporter.this.bFile.setSelection(true);
                    LabImporter.this.bDirect.setSelection(false);
                    FileDialog fdl = new FileDialog(parent.getShell(), 4096);
                    fdl.setFilterExtensions(new String[]{"*"});
                    fdl.setFilterNames(new String[]{Messages.ImporterPage_allFiles});
                    String filename = fdl.open();
                    if (filename == null) {
                        filename = "";
                    }
                    LabImporter.this.tFilename.setText(filename);
                    home.results[0] = new Integer(1).toString();
                    home.results[1] = filename;
                    CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/type", 1);
                    CoreHub.localCfg.set("ImporterPage/" + home.getTitle() + "/filename", filename);
                }
            });
        }
    }
}

