/*
 * Decompiled with CFR 0.152.
 */
package ch.berchtold.emanuel.privatrechnung.rechnung;

import ch.berchtold.emanuel.privatrechnung.rechnung.BerchtoldPrivatrechnungTextTemplateRequirement;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class RnPrintView
extends ViewPart {
    static final String ID = "ch.berchtold.privatrechung.view";
    static final double lineHeight = 0.63;
    TextContainer tc;
    Fall fall;

    public void createPartControl(Composite parent) {
        this.tc = new TextContainer(parent.getShell());
        this.tc.getPlugin().createContainer(parent, new ITextPlugin.ICallback(){

            public void save() {
            }

            public boolean saveAs() {
                return false;
            }
        });
    }

    public void setFocus() {
    }

    public Result<Rechnung> doPrint(Rechnung rn, Properties props) {
        Mandant sm = ElexisEventDispatcher.getSelectedMandator();
        if (sm == null || !sm.isValid()) {
            return new Result(Result.SEVERITY.ERROR, 1, "Kein Mandant eingeloggt", null, true);
        }
        String id = sm.getId();
        Result ret = new Result();
        this.fall = rn.getFall();
        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)this.fall);
        Kontakt adressat = this.fall.getGarant();
        if (!adressat.isValid()) {
            adressat = this.fall.getPatient();
        }
        List kons = rn.getKonsultationen();
        Collections.sort(kons, new Comparator<Konsultation>(){
            TimeTool t0 = new TimeTool();
            TimeTool t1 = new TimeTool();

            @Override
            public int compare(Konsultation arg0, Konsultation arg1) {
                this.t0.set(arg0.getDatum());
                this.t1.set(arg1.getDatum());
                return this.t0.compareTo((Calendar)this.t1);
            }
        });
        Money sum = new Money();
        HashMap<String, ArrayList<Verrechnet>> groups = new HashMap<String, ArrayList<Verrechnet>>();
        for (Konsultation k : kons) {
            List vv = k.getLeistungen();
            for (Verrechnet v : vv) {
                Money netto = v.getNettoPreis();
                netto.multiply((double)v.getZahl());
                sum.addMoney(netto);
                IVerrechenbar iv = v.getVerrechenbar();
                String csName = iv.getCodeSystemName();
                Object gl = (ArrayList<Verrechnet>)groups.get(csName);
                if (gl == null) {
                    gl = new ArrayList<Verrechnet>();
                    groups.put(csName, (ArrayList<Verrechnet>)gl);
                }
                gl.add(v);
            }
        }
        if (props.get("Summary").equals(Boolean.toString(true))) {
            this.tc.createFromTemplateName(null, BerchtoldPrivatrechnungTextTemplateRequirement.getESRTemplate(), "Rechnung", adressat, rn.getNr());
            this.fillFields();
            ESR esr = new ESR(CoreHub.mandantCfg.get("privatrechnung_berchtold/esrIdentity/" + id, ""), CoreHub.mandantCfg.get("privatrechnung_berchtold/esrUser/" + id, ""), rn.getRnId(), 27);
            Kontakt bank = Kontakt.load((String)CoreHub.mandantCfg.get("privatrechnung_berchtold/bank/" + id, ""));
            if (!bank.isValid()) {
                SWTHelper.showError((String)"Keine Bank", (String)"Bitte geben Sie eine Bank f\u00fcr die Zahlungen ein");
            }
            esr.printBESR(bank, adressat, (Kontakt)rn.getMandant(), sum.getCentsAsString(), this.tc);
            Object pos = this.tc.getPlugin().insertText("[Leistungen]", "Leistungspositionen\n", 16384);
            for (String k : groups.keySet()) {
                this.tc.getPlugin().setFont("Helvetiva", 1, 10.0f);
                pos = this.tc.getPlugin().insertText(pos, String.valueOf(k) + ":\t", 16384);
                this.tc.getPlugin().setFont("Helvetiva", 0, 10.0f);
                List lv = (List)groups.get(k);
                Money zeile = new Money();
                for (Verrechnet vv : lv) {
                    zeile.addMoney(vv.getNettoPreis().multiply((double)vv.getZahl()));
                }
                pos = this.tc.getPlugin().insertText(pos, "\t\t" + zeile.getAmountAsString() + "\n", 16384);
            }
            pos = this.tc.getPlugin().insertText(pos, "_____________________________________\nSumme\t\t\t" + sum.getAmountAsString(), 16384);
            this.tc.getPlugin().print(CoreHub.mandantCfg.get("Drucker/A4ESR/Name", null), null, false);
        }
        if (props.get("Detail").equals(Boolean.toString(true))) {
            double cmAvail = CoreHub.mandantCfg.get("privatrechnung_berchtold/templateBillHeight/" + id, 15.0);
            String toPrinter = CoreHub.mandantCfg.get("Drucker/A4/Name", null);
            this.tc.createFromTemplateName(null, BerchtoldPrivatrechnungTextTemplateRequirement.getBill1Template(), "Rechnung", adressat, rn.getNr());
            this.fillFields();
            Object pos = this.tc.getPlugin().insertText("[Leistungen]", "\n", 16384);
            sum = new Money();
            int page = 1;
            this.tc.getPlugin().setFont("Helvetica", 0, 8.0f);
            for (Konsultation k : kons) {
                String date = new TimeTool(k.getDatum()).toString(4);
                for (Verrechnet vv : k.getLeistungen()) {
                    Money preis = vv.getNettoPreis();
                    int zahl = vv.getZahl();
                    Money subtotal = new Money(preis);
                    subtotal.multiply((double)zahl);
                    StringBuilder sb = new StringBuilder();
                    sb.append(date).append("\t").append(zahl).append("\t").append(vv.getText()).append("\t").append(preis.getAmountAsString()).append("\t").append(subtotal.getAmountAsString()).append("\n");
                    pos = this.tc.getPlugin().insertText(pos, sb.toString(), 16384);
                    sum.addMoney(subtotal);
                    cmAvail -= 0.63;
                    if (!(cmAvail <= 0.0)) continue;
                    StringBuilder footer = new StringBuilder();
                    pos = this.tc.getPlugin().insertText(pos, "\n\n", 16384);
                    footer.append("Zwischentotal:\t\t").append(sum.getAmountAsString());
                    pos = this.tc.getPlugin().insertText(pos, footer.toString(), 16384);
                    if (!this.tc.getPlugin().print(toPrinter, null, false)) {
                        return new Result(Result.SEVERITY.ERROR, 2, "Fehler beim Drucken der Rn. " + rn.getNr(), null, true);
                    }
                    this.insertPage(++page, adressat, rn);
                    pos = this.tc.getPlugin().insertText("[Leistungen]", "\n", 16384);
                    cmAvail = CoreHub.mandantCfg.get("privatrechnung_berchtold/templateBillHeight2/" + id, 20.0);
                }
            }
            pos = this.tc.getPlugin().insertText(pos, String.valueOf(StringTool.filler((String)"_", (int)110)) + "\nTotal:\t\t\t\t" + sum.getAmountAsString(), 16384);
            this.tc.getPlugin().print(toPrinter, null, false);
        }
        return ret;
    }

    private void insertPage(int page, Kontakt adressat, Rechnung rn) {
        this.tc.createFromTemplateName(null, BerchtoldPrivatrechnungTextTemplateRequirement.getBill2Template(), "Rechnung", adressat, rn.getNr());
        this.fillFields();
        this.tc.replace("\\[Seite\\]", StringTool.pad((int)1, (char)'0', (String)Integer.toString(page), (int)2));
    }

    private void fillFields() {
        Kontakt versicherung = Kontakt.load((String)this.fall.getInfoString("Versicherung"));
        if (versicherung.isValid()) {
            this.tc.replace("\\?\\?Versicherung\\.Name\\?\\?]", versicherung.getLabel());
            this.tc.replace("\\?\\?Versicherung\\.Anschrift\\?\\?", versicherung.getPostAnschrift(true));
        }
    }
}

