/*
 * Decompiled with CFR 0.152.
 */
package ch.berchtold.emanuel.privatrechnung.data;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.data.VerrechenbarAdapter;
import ch.elexis.data.Xid;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.util.List;

public class Leistung
extends VerrechenbarAdapter {
    static final String TABLENAME = "CH_BERCHTOLD_PRIVATRECHNUNG";
    public static final String CODESYSTEM_NAME = "Privattarif";
    public static final String CODESYSTEM_CODE = "999";
    public static final String FIELD_NAME = "name";
    static final String VERSION = "0.3.3";
    public static final String XIDDOMAIN = "www.xid.ch/id/customservices/Privattarif";
    private static final String createDB = "CREATE TABLE CH_BERCHTOLD_PRIVATRECHNUNG(ID\t\t\t\tVARCHAR(25) primary key,deleted\t\tCHAR(1) default '0',lastupdate\tBIGINT,parent\t\t\tVARCHAR(80),name\t\t\tVARCHAR(499),short\t\t\tVARCHAR(80),cost\t\t\tCHAR(8),price\t\t\tCHAR(8),time\t\t\tCHAR(4),subsystem\t\tVARCHAR(25),valid_from\t\tCHAR(8),valid_until\tCHAR(8),ExtInfo\t\tBLOB);INSERT INTO CH_BERCHTOLD_PRIVATRECHNUNG (ID,name) VALUES ('VERSION','0.3.3');CREATE INDEX chelpr_idx1 on CH_BERCHTOLD_PRIVATRECHNUNG(parent,name);CREATE INDEX chelpr_idx2 on CH_BERCHTOLD_PRIVATRECHNUNG(valid_from);";
    private static final String UPDATE_033 = "ALTER TABLE CH_BERCHTOLD_PRIVATRECHNUNG ADD lastupdate BIGINT;";

    static {
        Leistung.addMapping((String)TABLENAME, (String[])new String[]{"parent", "Name=name", "Kuerzel=short", "Kosten=cost", "Preis=price", "subsystem", "Zeit=time", "DatumVon=S:D:valid_from", "DatumBis=S:D:valid_until", "ExtInfo"});
        Leistung check = Leistung.load("VERSION");
        if (check.state() < 2) {
            Leistung.createOrModifyTable((String)createDB);
        } else {
            VersionInfo v = new VersionInfo(check.get("Name"));
            if (v.isOlder(VERSION)) {
                Leistung.createOrModifyTable((String)UPDATE_033);
                check.set("Name", VERSION);
            }
        }
        Xid.localRegisterXIDDomainIfNotExists((String)XIDDOMAIN, (String)"Privatrechnung B", (int)1);
    }

    public static void createTable() {
        Leistung.createOrModifyTable((String)createDB);
    }

    public String getXidDomain() {
        return XIDDOMAIN;
    }

    public Leistung(String subsystem, String parent, String name, String kuerzel, String kostenInRp, String preisInRp, String ZeitInMin, String DatumVon, String DatumBis) {
        this.create(null);
        if (subsystem == null) {
            subsystem = "";
        }
        if (DatumVon == null) {
            DatumVon = "19700101";
        }
        if (DatumBis == null) {
            DatumBis = "20380118";
        }
        if (parent == null) {
            parent = "NIL";
        }
        this.set(new String[]{"parent", "Name", "Kuerzel", "Kosten", "Preis", "Zeit", "subsystem", "DatumVon", "DatumBis"}, new String[]{parent, name, kuerzel, kostenInRp, preisInRp, ZeitInMin, subsystem, DatumVon, DatumBis});
    }

    public String getCodeSystemCode() {
        return CODESYSTEM_CODE;
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    public String getLabel() {
        return this.get("Name");
    }

    public String getText() {
        return this.get("Name");
    }

    public String getCode() {
        return this.get("Kuerzel");
    }

    public Money getKosten(TimeTool dat) {
        return new Money(Leistung.checkZero((Object)this.get("Kosten")));
    }

    public int getMinutes() {
        return Leistung.checkZero((Object)this.get("Zeit"));
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String[] getDisplayedFields() {
        return new String[]{"Name", "Preis"};
    }

    public double getFactor(TimeTool date, IFall fall) {
        return this.getVKMultiplikator(date, fall);
    }

    public int getTP(TimeTool date, IFall fall) {
        return Leistung.checkZero((Object)this.get("Preis"));
    }

    public static Leistung load(String id) {
        return new Leistung(id);
    }

    protected Leistung() {
    }

    protected Leistung(String id) {
        super(id);
    }

    public boolean isDragOK() {
        return true;
    }

    public List<Object> getActions(Object context) {
        return null;
    }
}

